# NOTE: Derived from ./abmasterd/anyboard_mod9/abmain.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package abmain;

#line 673 "./abmasterd/anyboard_mod9/abmain.pm (autosplit into abmasterd/anyboard_mod9/auto/abmain/hYa.al)"
#x1
sub hYa { 

return if $abmain::cfg_inited;
$abmain::cfg_inited = 1;

%abmain::user_stats=(
B => "Banned: cannot login, cannot post",
C => "Disabled: cannot login, cannot post",
V => "Validated: pending approval, cannot post",
A => "Active Member"
);

%abmain::thread_sorters =(
yTz=>"Last post time in the thread",
zCz=>"Average post time in the thread",
mM=>"First post time in the thread",
hC=>"Author name",
wW=>"Topic",
fI =>"Message sequence number",
size=>"Message size",
mood=>"Message emotion",
sort_key=>"Message sort key"
);
@abmain::cat_tags=qw(AB_CAT_DESC AB_CAT_NAME AB_CAT_NEWS AB_CAT_GUIDE AB_SUGGEST_CAT_LNK AB_CREATE_CAT_LNK AB_CAT_FORUM_LIST AB_VIEW_CAT_LIST_LNK
AB_CREATE_FORUM_LNK AB_SUB_CAT_LIST AB_MODIFY_CAT_LNK
);

@abmain::months = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);

%abmain::user_types=(
A =>"A: can't post",
B =>"B: access restricted",
C =>"C: post moderated",
D =>"D: not in use",
E =>"E: full access"
);

@abmain::error_cfg=([e_info =>"head", "Error message"]);

for(keys %abmain::cP) {
 $ecref = $abmain::cP{$_};
 push @error_cfg, [$_."_e0", "text", "size=40", $ecref->[0]. "(short)", $ecref->[0]];
 push @error_cfg, [$_."_e1", "text", "size=40", $ecref->[0]. "(description)", $ecref->[1]];
 push @error_cfg, [$_."_e2", "text", "size=40", $ecref->[0]. "(suggestion)", $ecref->[2]];
};

@abmain::core_cfgs=();

@abmain::forum_org_info_cfgs=(
[global_info =>"head", "Organization Information"], 
[ab_org_name =>"text", 'size=40', "Organization name (ORG_NAME)"],
[ab_org_url=>"text", 'size="40"', "Organization home URL (ORG_URL)"],
[ab_org_logo=>"htmltext", "rows=4 cols=48", "Organization logo HTML code (OR_LOGO)"],
[ab_org_contact_info=>"textarea", "rows=3 cols=40", "Organization contact information (ORG_CONTACT_INFO)"],
[ab_org_address=>"textarea",  "rows=3 cols=40", "Organization address (ORG_ADDRESS)"],
[ab_org_copyright=>"textarea", "rows=3 cols=40", "Organization copyright notice (ORG_COPYRIGHT)"],
[ab_org_help_info=>"htmltext", "rows=3 cols=40", "Organization site help information link (ORG_HELP_INFO)"],
[ab_org_service_info=>"htmltext", "rows=3 cols=40", "Organization customer service information link (ORG_SERVICE_INFO)"],
[ab_org_about_info=>"htmltext", "rows=3 cols=40", "Organization about us information link (ORG_ABOUT_INFO)"],
[ab_org_news_info=>"htmltext", "rows=3 cols=40", "Organization news information link (ORG_NEWS_INFO)"],
[ab_org_search_box=>"htmltext", "rows=3 cols=40", "Organization search box HTML (ORG_SEARCH_BOX)"],
[ab_org_products_info=>"htmltext", "rows=3 cols=40", "Organization products information link (ORG_PRODUCTS_INFO)"],
[ab_org_sales_info=>"htmltext", "rows=3 cols=40", "Organization sales information link (ORG_SALES_INFO)"],
[ab_org_partner_info=>"htmltext", "rows=3 cols=40", "Organization partner information link (ORG_PARTNER_INFO))"],
[ab_org_top_nav_bar=>"htmltext", "rows=3 cols=40", "Organization site page top navigation bar (ORG_TOP_NAV_BAR))"],
[ab_org_left_bar=>"htmltext", "rows=3 cols=40", "Organization site page left side bar (ORG_LEFT_BAR))"],
[ab_org_right_bar=>"htmltext", "rows=3 cols=40", "Organization site page right side bar (ORG_RIGHT_BAR))"],
[ab_org_bottom_nav_bar=>"htmltext", "rows=3 cols=40", "Organization site page bottom navigation bar (ORG_BOTTOM_NAV_BAR))"],
[ab_org_top_banner=>"htmltext", "rows=3 cols=40", "Organization site page top banner (ORG_TOP_BANNER))"],
[ab_org_bottom_banner=>"htmltext", "rows=3 cols=40", "Organization site page bottom banner (ORG_BOTTOM_BANNER))"],
);

push @abmain::core_cfgs, qw(ab_org_name ab_org_url ab_org_logo ab_org_copyright);
@abmain::rC = (
["forum_cfg", "head", "Forum Name And File Extension"], 
["name", "text", 'size=60', "Name of the Forum", "Forum Powered By AnyBoard"], 
[forum_desc =>"htmltext", "rows=3 cols=48", "Forum Description", ""],
[forum_desc_full=> "htmltext", "rows=6 cols=48 wrap=soft", "Forum detail description",], 
[forum_idx=>"text", "", "Forum sort key used for the ablist command. Forum name will be used if this is not set.", ""],
[forum_logo=>"icon", "size=40", "Logo HTML of the forum", qq(<img src="$abmain::img_top/idea.gif">)],
[forum_cat =>"text", "size=20", "Category index of the forum (must match the one of the index defined in master admin)", "A"],
["no_list_me", "checkbox", "value=1", "Do NOT list this forum", "0"], 
["no_list_moders", "checkbox", "value=1", "Do NOT show moderators of this forum", "0"], 
[iGz=> "text", 'size=40', "License key", ""],
["aC", "text", 'size=60', "File name of the main forum page", "index.html"], 
[idx_file =>"text", "size=60", "Name of the group interface page", "gindex.html"],
[links_file =>"text", "size=60", "Name of the links page", "links.html"],
["pollidxfile", "text", 'size=60', "File name of the poll index page", "index.html"], 
["ext",  "text", 'size="10"', "Extension of other HTML files, such as html, shtml", "html"],
["txt_encoding",  "text", 'size="10"', "Text encoding", "iso-8859-1"],
["passd",  "text", 'size="60"', "Absolute path to password directory, if different from default", ""],
["seqdir",  "text", 'size="60"', "Absolute path to sequence number directory, if different from default", ""],
);

push @abmain::core_cfgs, qw(name forum_desc forum_desc_full forum_logo forum_cat);

@abmain::aclist= keys %abmain::user_stats;
@abmain::utlist= keys %abmain::user_types;
@abmain::tslist= keys %abmain::thread_sorters;
$user_stat_sel = abmain::aRa(\%abmain::user_stats, \@abmain::aclist);
$user_type_sel = abmain::aRa(\%abmain::user_types, \@abmain::utlist);
$thread_sort_sel = abmain::aRa(\%abmain::thread_sorters, \@abmain::tslist);

@abmain::eT = (
["pol_info", "head", "Forum Control Policy"], 
[mFa=>"checkbox", "value=1", "Make forum page dynamic", 0],
[dyna_forum=>"checkbox", "value=1", "Make all pages dynamic, no direct HTML page access (CPU intensive)", 0],
[publish_ulist=>"checkbox", "value=1", "Publish active user list", 1],
#x1
#x1
["short_reg_form", "checkbox", "value=1", "Use short user registration form", "1"], 
["random_seq", "checkbox", "value=1", "Randomize message sequence numbers", "0"], 
["force_cookie", "checkbox", "value=1", "Require posters to enable Cookies", "0"], 
["xC", "checkbox", "value=1", "Display aliases of the author", "1"], 
["yJz", "checkbox", "value=1", "Do NOT display administrator aliases", "1"], 
["auto_fill", "checkbox", "value=1", "Auto fill E-mail address", "1"], 
[gOz=>"checkbox", "value=1", "Do NOT show link to forum on login and register form.", "0"],
[gBz => "checkbox", 'value=1', "Allow users to register with name and password.", "1"],
[gAz => "checkbox", 'value=1', "Enforce user password registration. User must be authenticated to post message", "0"],
[ask_on_reg=> "checkbox", 'value=1', "User must answer the following question correctly to register.", "0"],
[reg_question=>"text",  "size=60", "Question to ask on registration.", "Which forum software is the best?"],
[reg_answer=>"text", "size=60", "Answer to the question above", "AnyBoard"],
["inval_ans_err", "textarea", "", "Error message when registering user does not answer question correctly", "You did not correctly answer the question"],
[force_http_auth => "checkbox", 'value=1', "Poster must be authenticated by http server", "0"],
[http_auth_only => "checkbox", 'value=1', "Always use http server authenticated REMOTE_USER as Poster name", "0"],
[bUz=> "checkbox", 'value=1', "Do not share user and password among different forums", "0"],
#x1
#x1
#x1
[local_control=> "checkbox", 'value=1', "When users are shared among different forums, enable local control ", "0"],
[record_rhost=> "checkbox", 'value=1', "Record posters' hostname besides IP address", "0"],
#x1
[no_moder_priv=> "checkbox", 'value=1', "Do NOT moderate private messages", "1"],
#x1
#x1
[fBz=> "checkbox", 'value=1', "CC validation e-mail to admin", "0"],
[mWz=> "checkbox", 'value=1', "Allow user to request new password back by email", "1"],
["jDz",  "text", 'size=60', "List of forbidden email patterns separated by |", "\@free_email.com|\@junk_mail.com"],
["allowed_emails",  "text", 'size=60', "List of allowed email patterns separated by |", ""],
[enable_login => "checkbox", 'value=1', "Enable user login. Once logged in, user does not need to enter user name again", "1"],
[tHa => "checkbox", 'value=1', "Require user to login first to post message", "0"],
#x1
#x1
#x1
[allow_body_search=> "checkbox", 'value=1', "Allow user to search message body (CPU intensive)", "0"],
[allow_umail=> "checkbox", 'value=1', "Allow user to send emails to each other", "1"], 
["forbid_names",  "text", 'size=60', "List of forbidden names separated by |", "TEST"],
[sF =>"text", "size=16", "Disallow user after this many violations", "4"],
#x1
[vAz=> "text", '', "Minimum interval between posting stats generation (in seconds)", "7200"],
[kXz=> "checkbox", 'value=1', "Delete uploaded file when automatic purge ", "1"],
#x1
#x1
#x1
[pH => "checkbox", "value=1", "Log errors", "0"],
[qG=> "checkbox", 'value=1', "Enable file locking for maximum system integrity. Use this feature if your system supports it", "1"],
[disk_quota=>"text", "", "Maximum disk usage in MB (unit is MB)", "500"],
);

push @abmain::core_cfgs, qw(gBz gAz aWz require_email_nv rH enable_login tHa);
push @abmain::core_cfgs, qw(forbid_words filter_words xD lDz upfile_ext eJ);

@abmain::tL=(
["pol_info", "head", "Forum Posting Restriction "], 
["enable_voting", "checkbox", 'value=1', "Enable poll function", "1"],
["gMz", "checkbox", 'value=1', "Allow only admin or moderator to post new message", "0"],
#x1
#x1
#x1
#x1
["eJ", "checkbox", 'value=1', "Disallow posting. Freeze the forum", "0"],
["gL", "checkbox", 'value=1', "Disable followup.", "0"],
["fW", "checkbox", 'value=1', "Disable message link threading. Show message links linearly", "0"],
["forbid_words", "perlre", 'size=60', "List of forbidden words and patterns, separated by | (or any Perl RE)", "dirtyword1|dirtyword2"],
["filter_words", "perlre", 'size=60', "List of filtered words/patterns which will be silently replaced by blanks, separated by | (or any Perl RE)", ""],
["xD", "perlre", 'size=60', "List of blocked IP addresses, separated by | (or a general RE)", ""],
["allowed_ips", "perlre", 'size=60', "List of allowed IP addresses, separated by | (or a general RE)", ""],
#x1
#x1
#x1
[scare_msg=> "htmltext", 'rows=4 cols=60 wrap=soft', "Warning message when forbidden words are detected", "<font color=red size=+1><b>If you continue to use forbidden language, you will be disallowed from this forum. </font>"],
[scare_adm_msg=> "htmltext", 'rows=4 cols=48 wrap=soft', "Warning message when failed admin login is detected", "<font color=red size=+1><b>This area is restricted. Try to gain unauthorized access is unlawful !!!!</b></font>\n"],
[qV => "checkbox", 'value=1', "Allow HTML in message body", "1"],
[mKz => "checkbox", 'value=1', "Strip HTML tags in message body", "0"],
[no_carry_subj=> "checkbox", 'value=1', "Do NOT carry subject line over in reply", "0"],
[qNz=> "checkbox", 'value=1', "Collapse multiple REs", "1"],
[hBz=> "checkbox", 'value=1', "Quote original text when reply", "0"],
[xL=>"checkbox", "value=1", "Allow user to add link URL", "1"],
[oPz=>"checkbox", "value=1", "Do not show related link in message", "0"],
[xA=>"checkbox", "value=1", "Allow user to add image", "0"],
[take_email=>"checkbox", "value=1", "Allow user to input e-mail address", "0"],
[take_sort_key=>"checkbox", "value=1", "Allow admin to set sort key for messages", "0"],
[take_key_words=>"checkbox", "value=1", "Allow user to set key words for messages", "0"],
[qCz=>'checkbox', "value=1", "Allow admin to add links, even if it is generally disabled", "0"], 
[take_file=>"checkbox", "value=1", "Enable file uploading", "1"], 
#x1
#x1
#x1
[pIz=>"checkbox", "value=1", "Do not show uploaded files in message", "0"],
[oLz=>"checkbox", "value=1", "Do not allow read access to uploaded files", "0"],
[qDz=>"checkbox", "value=1", "Allow overwrite uploaded files", "0"],
[auto_rename_file=>"checkbox", "value=1", "Automatically rename uploaded file if a file with the same name exists", "1"],
[rL => "checkbox", 'value=1', "Allow user to modify message after posting", "1"],
[link_edit => "checkbox", 'value=1', "Link user name on the index page to modify message page", "1"],
[allow_usr_collapse=> "checkbox", 'value=1', "Allow user to collapse or close their threads", "1"],
#x1
[gZz => "checkbox", 'value=1', "Message can be modified only if posted by registered user", "1"],
#x2
[allow_del_priv=> "checkbox", 'value=1', "Always allow user to delete his private message", "1"],
#x1
[rR => "checkbox", 'value=1', "Allow message body to be empty", "1"],
[allow_no_reply => "checkbox", 'value=1', "Allow user to disallow replies to his posts", "1"],
[oCz => "checkbox", 'value=1', "Fix subject to Re: old subject", "0"],
[zP=> "checkbox", 'value=1', "Allow user to rate the posts", "1"],
[rate_low=> "text", "", "Lowest rate", "-5"],
[rate_high=> "text", "", "Highest rate", "5"],
[rTz=> "text", "", "Offset rate display by (so fraction will show up as 1)", "0.3"],
[rRz=> "checkbox", 'value=1', "Only registered user can rate", "0"],
[rate_wt_reg=> "text", 'size=4', "Rate weight of registered users", "1"],
[rate_wt_adm=> "text", 'size=4', "Rate weight of administrator", "5"],
[bLz=> "text", "", "Show rating only after this many votes", "2"],
[min_rate=> "text", "", "Do not display posts with rating lower than", "0"],
[rYz=> "text", "", "Hide low rating posts only after this many votes", "2"],
[qJ => "text", "", "Maximum length of message subject", "160"],
[xVz => "text", "", "Truncate subject displayed on main index to this many characters", "160"],
[sO => "text", "", "Maximum length of author name", "40"],
[name_hacks=> "text", "", "Auto Posting Names(seprate by ,)", "admin"],
[rUz=>"checkbox", 'value=1', "Limit text field length to the allowed length", "1"],
[qK => "text", "", "Maximum length of message body", "64000"],
[yR => "checkbox", "value=1", "Allow duplicated subject from same IP", "0"],
[yN => "text", "", "Minimum time interval between two posts from the same IP (unit is second)", "10"],
[max_match_cnt=> "text", "", "Maximum number of matches returned from a search", "500"],
#x1
#x1
#x1
[max_extra_uploads=> "text", "", "Maximum number of additional files to be uploaded in a post", "5"],
#x1
[yU=>"text", "size=8", "E-mail Admin if 20 messages arrive within less than this many seconds", "0"],
[qR=>"checkbox", "value=1", "Allow user to view configurations of the forum", "0"],
["rule_file"=> "text", 'size=60', "Physical path (not URL) to the forum usage agreement file", ""],
["rules"=> "htmltext", 'rows=8 cols=48', "OR: Forum usage rules", ""],
);

@abmain::eWz =(
[jQ => "head", "Forum Font Configuration"], 
[topic_font=>"text", "size=40", "Font attribute of the subject of the top message", $abmain::dfa],
[eSz=>"text", "size=40", "Font attribute of the message subject", $abmain::dfa],
[fEz=>"text", "size=40", "Font attribute of the author name", $abmain::dfa],
[author_font_msg=>"text", "size=40", "Font attribute of the author name inside message", $abmain::dfa],
[reg_author_font=>"text", "size=40", "Font attribute of registered author", qq($abmain::dfa color="#000099")],
[fCz=>"text", "size=40", "Font attribute of the posting date in message list", $abmain::dfa],
[date_font_msg=>"text", "size=40", "Font attribute of the posting date in message body", $abmain::dfa],
[eVz=>"text", "size=40", "Font attribute of the posting size", $abmain::dfa],
[eTz=>"text", "size=40", "Font attribute of the visit count", $abmain::dfa],
[followcnt_font=>"text", "size=40", "Font attribute of the followups count", $abmain::dfa],
[fHz=>"text", "size=40", "Font attribute of the message body", $abmain::dfa],
[quote_txt_font=>"text", "size=40", "Font attribute of quoted text", qq($abmain::dfa color="#222233")],
[abs_font=>"text", "size=48", "Font attribute of the message abstract", qq(size=1)],
[fDz=>"text", "size=40", "Font attribute of the forum name on the nav bar", $abmain::dfa],
[msg_cnt_font=>"text", "size=40", "Font attribute of the message counter on the nav bar", qq(size=1)],
[eYz=>"text", "size=40", "Font attribute of the message title (in message file)", qq(face="Verdana" size="+1")],
[cRz=>"text", "size=40", "Font attribute of admin name when posting", "color=red $abmain::dfa"],
[moder_font=>"text", "size=40", "Font attribute of moderator name when posting", "color=#cc0000 $abmain::dfa"],
[user_fonts=>"textarea", "rows=6 cols=48", "Font attribute of selected user names, in the format: user=font_attribute, one on each line.  ", qq(color="#ffcc00" $abmain::dfa), qq(user1=color=red\nuser2=color="red" face="Arial")],
[user_subj_fonts=>"textarea", "rows=6 cols=48", "Font attribute of subjects by selected user names, in the format: user=font_attribute, one on each line.  ", qq(color="#ffcc00" $abmain::dfa), qq(user1=color=red\nuser2=color="red" face="Arial")],
[cfg_head_font =>'text', "size=40", "Font attribute of the heading in config forms", qq(size="2" face="Verdana" color="#000000")],
[lab_font =>'text', "size=40", "Default font attribute of the labels", qq(color="#000000" face="Verdana" size="1")],
[btn_preview=>"submit", "value=Preview", "Click to preview", ""],
);

@abmain::group_setting = qw(
[displayinfo=>"head", "Group settings"],
["auto_fill", "checkbox", "value=1", "Auto fill E-mail address", "1"], 
[record_rhost=> "checkbox", 'value=1', "Record posters' hostname besides IP address", "0"],
[allow_body_search=> "checkbox", 'value=1', "Allow user to search message body (CPU intensive)", "0"],
[allow_umail=> "checkbox", 'value=1', "Allow user to send emails to each other", "1"], 
[sF =>"text", "size=16", "Disallow user after this many violations", "4"],
[take_file=>"checkbox", "value=1", "Enable file uploading", "1"], 
#x1
[rL => "checkbox", 'value=1', "Allow user to modify message after posting", "1"],
#x1
[qDz=>"checkbox", "value=1", "Allow overwrite uploaded files", "0"],
[topic_font=>"text", "size=40", "Font attribute of the subject of the top message", $abmain::dfa],
[eSz=>"text", "size=40", "Font attribute of the message subject", $abmain::dfa],
[fEz=>"text", "size=40", "Font attribute of the author name", $abmain::dfa],
[author_font_msg=>"text", "size=40", "Font attribute of the author name inside message", $abmain::dfa],
[fHz=>"text", "size=40", "Font attribute of the message body", $abmain::dfa],
[eYz=>"text", "size=40", "Font attribute of the message title (in message file)", qq(face="Verdana" size="+1")],
);
@abmain::lAz =(
[jQ => "head", "Emotion Icon Configuration "], 
[allow_mood => "checkbox", 'value=1', "Allow showing mood", "1"],
[sm_happy=>"icon", "size=60", "Happy smiley", qq(<img src="$abmain::img_top/smile.gif" alt="Smile">)],
[sm_sad=>"icon", "size=60", "Sad", qq(<img src="$abmain::img_top/sad.gif" alt="Sad">)],
[sm_scream=>"icon", "size=60", "Screaming", qq(<img src="$abmain::img_top/yuk.gif" alt="Yell">)],
[sm_angry=>"icon", "size=60", "Angry", qq(<img src="$abmain::img_top/angry.gif" alt="Angry">)],
[sm_laugh=>"icon", "size=60", "Laughing", qq(<img src="$abmain::img_top/question.gif" alt="Question">)],
[sm_kiss=>"icon", "size=60", "Kiss", qq(<img src="$abmain::img_top/idea.gif" alt="Idea">)],
[sm_x1=>"icon", "size=60", "Mood +1", qq(<img src="$abmain::img_top/agree.gif" alt="Agree">)],
[sm_x2=>"icon", "size=60", "Mood +2", qq(<img src="$abmain::img_top/disagree.gif" alt="Disagree">)],
[sm_x3=>"icon", "size=60", "Mood +3", ''],
[sm_x4=>"icon", "size=60", "Mood +4", ''],
[btn_preview=>"submit", "value=Preview", "Click to preview", ""],
);

push @abmain::core_cfgs, qw(allow_mood sm_happy sm_sad sm_scream sm_angry sm_laugh sm_kiss);

#[show_menu=>"checkbox", "value=1", "Display popup menu", "0"],

@abmain::cSa =(
[jQ => "head", "Message Category Configuration "], 
[allow_subcat=> "checkbox", 'value=1', "Enable message category", "0"],
[no_null_subcat=> "checkbox", 'value=1', "User must select a category", "1"],
[show_cat_jump=> "checkbox", 'value=1', "Display jump box for categories", "1"],
[grp_subcat=> "checkbox", 'value=1', "Group messages by category", "1"],
[scat_font=>"text", "size=48", "Font attribute of the message category", $abmain::dfa],
[scat_tb_attr=>"textarea", "rows=2 cols=48", "Additional table attribute of the category heading",qq(border="0" bgcolor="#ffffcc")],
[scat_use_radio=> "checkbox", 'value=1', "Use radio buttons instead of select box for category choices. This is necessary if you want to use html code such as IMG TAG in labels.", "0"],
[catopt=>"textarea", "rows=16 cols=48", "User category choices, one per line, in the format index=label. Categories will be listed in ascending order of indexes.","", undef, "=Select Category\nB=General Discussions\nC=Questions"],
[hBa=>"textarea", "rows=16 cols=48", "Additional categories choices restricted to administrator, one per line, in the format index=label. These categories will be combined with the categories above. Their indices cannot overlap.","", undef, "1=Announcements\nx=AnyBoard Usage "],
[scat_fix=>"text", "", "Category index for messages without a category, such as old messages", ""],
[btn_preview=>"submit", "value=Preview", "Click to preview", ""],
);

push @abmain::core_cfgs, qw(allow_subcat scat_font scat_tb_attr catopt);

@abmain::cRa=(
[jQ => "head", "Form Mail Configuration"], 
[fm_instruct=>'const', "", "Instruction", qq!AnyBoard can be used to process any web forms, including forms with file-upload fields, and save or email the result back to you. 
To use it, set the ACTION of your form to http://your-domain/your-cgi-dir/anyboard.cgi/iGa/, and add a hidden field named
"cmd" with value equals "procform"<br>(&lt;input type="hidden" name="cmd" value="procform"&gt;)!],
[cNa=> "checkbox", 'value=1', "Enable web form processing", "1"],
[formreferer_match=>"text", "size=48", "HTTP referer must match this pattern", ""],
[cLa=> "checkbox", 'value=1', "User must login AnyBoard to use the form mail", "0"],
[cVa=>"textarea", "cols=48 rows=2", "E-mail(s) of the recipient(s)", ""],
[cWa=>"text", "size=40", "Directory to store uploaded files ( if not set uploaded files will be discarded )", ""],
[cMa=>"textarea", "cols=48 rows=6 wrap=soft", "Header of the form submission confirmation page", "<html><body>"],
[cPa=>"textarea", "cols=48 rows=6 wrap=soft", "Footer of the form submission confirmation page", "</body></html>"],
);

@abmain::forum_style_cfgs=(
[jQ => "head", "Forum Style"], 
[try_wysiwyg=> "checkbox", 'value=1', "Enable WYSIWYG HTML editing for IE browser", "1"],  
[sAz=> "textarea", "rows=8 cols=48 wrap=soft ", "Forum style code", 
qq(<STYLE type="text/css">
<!--
H1 {font-size: 20pt; text-align: center}
TH {font-size: 11pt; font-family: "Arial, Helvetica, sans-serif"}
HTML, BODY, TD {font-size: 10pt; font-family: "Arial, Helvetica, sans-serif"}
UL {list-style: disc}
DIV.ABMEMBERLIST TD {font-size: 8pt; color: #003300; font-family: "Arial, Helvetica, sans-serif"}
DIV.ABMSGBODY {font-size: 10pt; font-family: "Arial, Helvetica, sans-serif"}
DIV.ABCONFLIST TD{font-size: 10pt; font-family: "Arial, Helvetica, sans-serif"}
A:hover { color: #007FFF; text-decoration: underline; background-color: #ffee00;}
.ABMSGLIST, .ABMSGBODY, .PFTDL, .PFTDR, .CHATAREA {font-size: 10pt; font-family: "Arial, Helvetica, sans-serif"}

/*The message area */
.ABMSGAREA {font-size: 10pt; font-family: "Arial, Helvetica, sans-serif"; text-align: center}

/*Table of the navigation bar*/
TABLE.NAV A{color:#000000; font-weight:900; text-decoration: none}

/*Left TD of the configuration forms */
TD.PFTDL {background-color: #666666; color: #ffffff}

/*Table contains configuration form */
TABLE.CFG { background-color: #000000; border-width: 1; border-color: #666666; border-style: solid; }

/*Header of the row-column data table */
TD.RowColTableHeader {font-size: 12pt; font-family:Verdana; font-weight: bold; }
TD.RowColTableSubHeader {font-size:12pt; font-family:Arial; font-weight: bold; }

/*Bottom TD of the row-column data table */
TD.RowColTableCaption {background-color: #dddddd}

/*Table contains the even numbered threads*/
TABLE.ThreadTable0 {border:0}

/*Table contains the odd numbered threads*/
TABLE.ThreadTable1 {border:0}

/*Row for the message header */
TR.MsgRowHeader {background-color: #000044; color: #ffcc00; font-family: Verdana; font-weight:bold; font-size:14px}
TR.MsgRowHeaderBottom {background-color: #000044; color: #ffcc00; font-family: Verdana; font-weight:bold}

/*Table that contains the post message form */
TABLE.PostMessageForm { border-width:1; border-color: #666666; border-style: solid; }

/*Table that contains the polls */
TABLE.PollsTable{ border-width:1; border-color: #666666; border-style: solid; }

/*Text prompt on the configuration forms */
.AB-form-prompt { font-family: Arial; font-size: 14pt; }

/*The span that contains chat user name*/
.ChatUserName {}

/*The span that contains one line of chat message*/
.ChatMessageLine {}

-->
</STYLE>
)],
#x1
#x1
[nolink_nt=> "checkbox", 'value=1', "Do not link to empty message on index page", "1"],
[xYz=>"textarea", "rows=1 cols=48 wrap=soft", "Additional attribute for the message links", qq(STYLE="text-decoration: none")],
[xXz=>"textarea", "rows=1 cols=48 wrap=soft", "Additional attribute for the author name links", ""],
[yAz=>"textarea", "rows=1 cols=48 wrap=soft", "Additional attribute for the related link inside a message", ""],
[xZz=>"textarea", "rows=1 cols=48 wrap=soft", "Additional attribute for the user added link inside a message", ""],
[tz_offset=>"text",  "size=4", "Offset time display by this many hours (can be negative)", "0"], 
[lJ => "checkbox", 'value=1', "Inline followup messages", "0"],
[aO => "checkbox", 'value=1', "Inline all messages (like a guest book)", "0"],
[mJ => "checkbox", 'value=1', "Thread inline message text", "0"],
["flat_tree", "checkbox", 'value=1', "Flatten the message threads", "0"],
[no_show_poster=> "checkbox", 'value=1', "Do NOT display author name on index page", "0"],
[no_show_time=> "checkbox", 'value=1', "Do NOT display posting time on index page", "0"],
[top_abstract_len=> "text", '', "Maximum length of abstract of top level topic ( set to 0 to disable )", "0"],
[auto_href_abs=> "checkbox", 'value=1', "Auto link URLs in the abstract", "1"],
[read_more_abs=> "checkbox", 'value=1', "Show read more link at the end of abstract", "1"],
[abs_begin => "textarea", 'rows=4 cols=60', "HTML code before the abstract", qq(<div style="margin-left: 3mm; margin-right:3mm">)],
[abs_end=> "text", 'size=48', "HTML code after the abstract", qq(...</div>)],
[collapse_age=>"text",  "size=4", "Collapse threads older than this many hours", "24000"], 
[hG=>"text", "", "Depth of links on main page", ""],
[no_links_inmsg=>"checkbox", "value=1", "Do not show links to replies inside message", "0"],
[yVz => "select", $thread_sort_sel, "Sort threads by", "mM"],
[revlist_topic => "checkbox", 'value=1', "List threads in ascending order ( older thread on TOP if time is used for sorting )", "0"],
[revlist_reply => "checkbox", 'value=1', "List old replies first", "1"],
[use_square=>"checkbox", "value=1", "Use square for unordered list", "0"],
[no_li=>"checkbox", "value=1", "Do not use list item for threaded messages", "0"],
[lVz=>"checkbox", "value=1", "Do not use unorder list to thread messages, use spacers for indentation", "0"],
[lUz=>"text", "size=60", "Indentation spacer before message links if is not used", "<font color=#ffffff>-----</font>"],
[mAz=>"checkbox", "value=1", "Align message links ( subject, name, date ) in columns", "0"],
[qLz=>"text", "size=60", "Attribute of the subject column", qq(width="60%")],
[qMz=>"text", "size=60", "Attribute of the name column", qq(width="15%" bgcolor="#eeeeff")],
[qPz=>"text", "size=60", "Attribute of the date column", qq(width="25%" align=right bgcolor="#ffffcc")],
[align_col_new=>"checkbox", "value=1", "Align message attributes with the following row layout, this setting allows great flexibility and override the settings above ", "0"],
[msg_row_layout=>"textarea", "rows=8 cols=70", "Layout of the message row. AnyBoard will wrap your layout with a TR element , so the layout must consist of TD tags. Available macros:<br>".join("<br>", @lB::msg_macs),
qq(
<td width="20">MSG_STAT_TAG</td>
<td width="20" bgcolor="#cccccc">MSG_MOOD</td>
<td><MSG_SPACER>MSG_LINK<MSG_FLAGS></td>
<td bgcolor="#cccccc">MSG_POSTER</td> 
<td>MSG_REPLY_CNT</td>
<td>MSG_RATE_LNK</td>
<td nowrap bgcolor="#cccccc">MSG_SIZE</td>
<td nowrap>MSG_TIME</td>
)
],
[msg_row_header=>"textarea", "rows=8 cols=70", "Layout of the message row header. Make sure this matches the row layout", 
qq(
<td width="40" colspan=2></td>
<td>Subject</td>
<td title="Who started this message">Originator</td> 
<td title="Number of replies">Replies</td>
<td title="Average rating">Rating</td>
<td title="Size of the message">Size</td>
<td title="When was the message posted">Time</td>
)
],
[msg_row_header_bottom=>"checkbox", "value=1", "Add message row header at the bottom", "0"],
[sub_top_bottom=>"checkbox", "value=1", "Put new followups of messages on previous page at the end", "0"],
[hEz=>"checkbox", "value=1", "Always show the full thread", "0"],
[yBz=>"checkbox", "value=1", "Try to group followups", "1"],
[show_msgnos4top=>"checkbox", "value=1", "Show message number for top level topic", "0"],
[show_msgnos4sub=>"checkbox", "value=1", "Show message number for followups", "0"],
[bOz=>"checkbox", "value=1", "Show subject in bold text", "0"],
[jCa=>"checkbox", "value=1", "Show dates in numeric format", "1"],
[bKz=>"checkbox", "value=1", "Show dates in short format", "0"],
[day_date=>"checkbox", "value=1", "Show dates in shortest format (month day)", "0"],
[posix_date=>"checkbox", "value=1", "Show dates in POSIX strftime format below (this takes highest precedence)", "0"],
[posix_df=>"text", "size=60", "strftime date format (see manual for formatting options)", '%Y-%m-%d %H:%M'],
[rM=>"checkbox", "value=1", "Show size of message body", "1"],
[yUz=>"checkbox", "value=1", "Show modification time for modified messages", "1"],
[bJz=>"checkbox", "value=1", "Show number of followups to a message", "1"],
[gSz=>"checkbox", "value=1", "Indicate on main page whether the user is registered", "0"],
[xJ=>"checkbox", "value=1", "Indicate if there is an image link in message", "1"],
[show_has_attach=>"checkbox", "value=1", "Indicate if there is an attachment in message", "1"],
[show_has_lnk=>"checkbox", "value=1", "Indicate if there is linked URL in message", "1"],
[show_rate_link_main=>"checkbox", "value=1", "Show rate message link on main index page", "1"],
[dAa=>"checkbox", "value=1", "Display rate after subject instead of date", "0"],
[gNz=>"checkbox", "value=1", "Do not show author's email address in message", "0"],
#x1
[compute_forum_list=>"checkbox", "value=1", "Show links to other forums", "0"], 
[fFz=> "text", "", "Show message which has more than this many visits as hot", "100"],
[redir_onread=> "text", "", "Use redirection on reading messages", "0"],
[iWa=>"checkbox", "value=1", "Do not show navigate and command bar at top", "0"], 
[rV=>"checkbox", "value=1", "Show navigate and command bar at bottom", "1"],
[show_plugin=>"checkbox", "value=1", "Show plugin banner", "1"],
[banner_freq=> "text", "", "Show one banner for this many threads", "10"],
[kF=> "text", "", "Show message less than this many minutes old as new ", "60"],
[adopt_orphan=> "checkbox", 'value=1', "Adopt orphan message", "1"],
[bPz=> "checkbox", 'value=1', "Add link to URL in the message", "1"],
[qH=> "checkbox", 'value=1', "Replace newline with \&lt;br\&gt;", "1"],
[pZz=>"checkbox", "value=1", "Show original message on reply page", "1"],
[xP=>"checkbox", "value=1", "Indent the followup links or texts", "0"],
[iW => "text", '', "Number of message links per page", "32"],
[dDz=>"checkbox", "value=1", "Use frame interface", "0"],
[reverse_frame=>"checkbox", "value=1", "Reverse frame positions", "0"],
[dAz =>"text", "size=40", "Frame set attribute", qq(COLS="40%, *")],
[uE =>"text", "size=40", "URL of the welcome page", "http://netbula.com/anyboard/"],
[display_info2 => "head", "More configurations"], 
[pform_tb_width=>"text", "", "Width of table enclosing the post message form", qq(75%)],
[pform_tb_attr=>"textarea", "rows=3 cols=48", "Additional attributes for the table enclosing the post message form", qq(cellspacing=1 cellpadding=2 align="center")],
[msg_form_cols=>"text", "", "Number of columns of the textarea in the post message form", "64"],
[pform_rows => "text", "", "Number of rows in the post form", "16"],
[rP =>"textarea", "rows=3 cols=48", "Separator between topics", ""],
[sn_sep =>"text", "size=60", "Separator between subject and author name( in non-aligned mode )", " --- "],
[nd_sep =>"text", "size=60", "Separator between author name and posting date( in non-aligned mode )", "("],
[ds_sep =>"text", "size=60", "Separator after posting date ( in non-aligned mode )", ")"],
[dsz_sep =>"text", "size=60", "Separator in front of message size", " ("],
[szo_sep =>"text", "size=60", "Separator between size and the rest", ") "],
[fc_tag => "text", "size=60", "Tag after followups count",  ""],
[topic_tag => "text", "size=60", "Leading TAG in front of topic, such as a folder icon", qq(<img src="$abmain::img_top/folder.gif">)],
[closed_tag => "text", "size=60", "Leading TAG in front of a closed topic", qq(<img src="$abmain::img_top/dark_folder.gif" alt="This thread is closed">)],
[sub_topic_tag => "text", "", "Leading TAG in front of sub topic showing on top", "|__"],
[hSa => "checkbox", "value=1", "Link the TAG in front of sub topic to Top thread", "1"],
[path_list_sep=> "htmltext", "rows=2 cols=48 wrap=soft", "HTML between message path links", " &gt;&gt; "],
[btn_preview=>"submit", "value=Preview", "Click to preview", ""],
);

push @abmain::core_cfgs, qw(sAz tz_offset lJ aO hG yVz  
align_col_new msg_row_layout msg_row_header dDz dAz iW);

#[cfg_head_bg =>'color', "", "Background color of the heading in config forms", "#a8a8a8"],
@abmain::forum_color_cfgs=(
[jQ => "head", "Forum Colors & Borders"], 
[cfg_head_bg =>'color', "", "Background color of the heading in config forms", "#6699cc"],
[cfg_bot_bg =>'color', "", "Background color of the submit area in config forms", "#efefee"],
[new_msg_color=> "color", "", "Text color for the date of new messages", "#008800"],
[mod_msg_color=> "color", "", "Text color for the date of newly modified messages", "#990000"],
[cbgcolor0 => "color", "size=48",  "Background color of configure form Entry", "#efefef"],
[cbgcolor1 => "color", "size=48",  "Background color of next configure form Entry", "#ffffff"],
[qP => "color", "size=48", "Background color of topic header,  can be set to empty", "#e5e5d1"],
[qQ => "color", "size=48", "Background color of next topic header",  "#efefef"],
[sM => "color", "size=48", "Text color of topic header",  "#000000"],
[sN => "color", "size=48", "Text color of next topic header", "#000000"],
[sP => "color", "size=48",  "Background color of followups ", "#ffffff"],
[sQ => "color", "size=48",  "Background color of followups of next topic", "#ffffff"],
[padsize => "text", "",  "Size of the space around message links", "2"],
[bdsize => "text", "",  "Width of the border around message links (0 is OK)", "0"],
[lZz => "text", "",  "Width of the border within message links (0 is OK)", "0"],
[bdcolor => "color", "size=48",  "Color of the borders", ""],
[usebd=>"checkbox", "value=1", "Add border around data listing tables", "1"],
[gridtab=>"checkbox", "value=1", "Chessboard table", "0"],
[bIz => "color", "size=48",  "Background color of quoted text ( when replying )", "#e5e5d1"],
[follow_bg => "color", "size=48",  "Background color of the followup links in message", ""],
[xM => "color", "size=48",  "Background color of the post message form", qq(#cccccc)],
[msg_bg=> "color", "size=48",  "Background color of the information pages", "#e5e5d1"],
[cZz => "color", "size=48",  "Background color of the command forms", "#e5e5d1"],
[btn_preview=>"submit", "value=Preview", "Click to preview", ""],
);

@abmain::forum_tag_cfgs=(
[jQ => "head", "Tag transformation"], 
[forum_tag_trans=>"textarea", "rows=28 cols=48", "Text transformation table, one per line, in the format text=replacement. Clear off to disable.", qq!:)=<img src="$abmain::img_top/smile_rotate.gif" border="0">!],
[kMa =>"checkbox", "value=1", "Transform subject", "1"],
[kNa=>"textarea", "rows=28 cols=48", "Text transformation table used inside messages only.", ""],
[avatar_trans=>"textarea", "rows=16 cols=60", "Avatars table, one per line, in the format id=img . Clear off to disable.", 
qq!barney_rubble=<img src="$abmain::img_top/ava_barney_rubble.gif">
bart=<img src="$abmain::img_top/ava_bart.gif">
biz_man=<img src="$abmain::img_top/ava_biz_man.gif">
blonde=<img src="$abmain::img_top/ava_blonde.gif">
brutus=<img src="$abmain::img_top/ava_brutus.gif">
duck=<img src="$abmain::img_top/ava_duck.gif">
felix_cat=<img src="$abmain::img_top/ava_felix_cat.gif">
garfield=<img src="$abmain::img_top/ava_garfield.gif">
gentleman=<img src="$abmain::img_top/ava_gentleman.gif">
girl=<img src="$abmain::img_top/ava_girl.gif">
girl_big_eye=<img src="$abmain::img_top/ava_girl_big_eye.gif">
huckleberryhound=<img src="$abmain::img_top/ava_huckleberryhound.gif">
inspector=<img src="$abmain::img_top/ava_inspector.gif">
penguin=<img src="$abmain::img_top/ava_penguin.gif">
poo_bear=<img src="$abmain::img_top/ava_poo_bear.gif">
popeye=<img src="$abmain::img_top/ava_popeye.gif">
red_nose=<img src="$abmain::img_top/ava_red_nose.gif">
sylvester=<img src="$abmain::img_top/ava_sylvester.gif">
tweetybird=<img src="$abmain::img_top/ava_tweetybird.gif">
white_rabbit=<img src="$abmain::img_top/ava_white_rabbit.gif">
young_man=<img src="$abmain::img_top/ava_young_man.gif">
!],
);

@abmain::fetch_url_cfg=(
[jQ => "head", "Download remote web objects to server"], 
[urls=>"textarea", "rows=28 cols=60", "URLs to download, one per line"],
);

@abmain::search_member_form=(
[jQ => "head", "Search members"], 
[pat=> "text", "size=40", "Match pattern"], 
[any=>"label", "", "Registration day range", qq(From <input type="text" size="4" name="hIz" value="7"> days ago, to <input type="text" size=4 name="hJz" value="0"> days ago)],
[cmd=>'hidden', "", "", "kPz"],
[regmatch=>'hidden', "", "", "1"],
);
@abmain::tG=(
[jQ => "head", "Forum Presentation"], 
[display_info1 => "head", "Forum Index Page"], 
[forum_header=> "hidden", "rows=6 cols=48 wrap=soft", "Forum header HTML, starting from \&lt;html\&gt;", ""],
[forum_banner=> "htmltext", "rows=6 cols=48 wrap=soft", "Forum banner HTML above the Top nav bar", 
qq(<p align="right"><LOGIN_USER><br><LOCAL_USER_LIST><br><PRIVATE_MSG_ALERT></p>)],
[forum_bottom_banner=> "htmltext", "rows=8 cols=48", "Forum bottom banner.", qq(<p align=right style="margin-right:5%">Powered by <a href="http://netbula.com/anyboard/">AnyBoard</a></p>)],
[forum_layout =>"hidden", "", "Forum index page layout"],
[forum_layout_new =>"htmltext", "rows=16 cols=48", "Forum index page layout (must contain macro FORUM_MSG_AREA)", 
qq(
<html>
<head>
</head>
<body>

<!---begin-->

<center>FORUM_AD</center>
FORUM_TOP_BANNER<br>
<center>
FORUM_DESC_FULL
FORUM_MSG_AREA
</center>
FORUM_BOTTOM_BANNER

<!---end-->

</body>
</html>
)],
[cWz=> "htmltext", "rows=6 cols=48 wrap=soft", "HTML between TOP navigation bar and message list",""],
[cYz=>"text", "", "Width of the message link area", "90%"],
[cXz=> "htmltext", "rows=6 cols=48 wrap=soft", "HTML between message list and bottom navigation bar ( if present )", ""],
[forum_footer=> "hidden", "rows=8 cols=48", "Forum footer HTML.", ''],

[display_info2 => "head", "Other Pages"], 
[form_banner=> "textarea", "rows=6 cols=48 wrap=soft", "Post form banner HTML"],
[regform_banner=> "textarea", "rows=8 cols=48", "Banner HTML of registration page"],
[loginform_banner=> "textarea", "rows=8 cols=48", "Banner HTML of login page"],

[other_page_layout=> "htmltext", "rows=16 cols=48 wrap=soft", "HTML template of other pages (must contain macro PAGE_CONTENT)", 
qq(<html>
<head></head>
<body bgcolor="#ffffff">
PAGE_CONTENT
</body>
</html>
)],

[other_header=> "hidden", "", "Header HTML of other pages, starting from \&lt;/head\&gt;\&lt;body\&gt;"],
[other_footer=> "hidden", "", "Footer HTML of other pages, ending with \&lt;/body\&gt; \&lt;/html&gt;", ""],

[btn_preview=>"submit", "value=Preview", "Click to preview", ""],
);

push @abmain::core_cfgs, qw(forum_header forum_banner cYz forum_bottom_banner forum_layout
forum_footer form_banner regform_banner loginform_banner other_header other_footer);
push @abmain::core_cfgs, qw(msg_header msg_banner msg_footer message_page_layout);

@abmain::forum_msg_cfgs=(
[jQ => "head", "Individual Message Page Layout"], 
[msg_banner=> "htmltext", "rows=16 cols=48 wrap=soft", "Message banner HTML, below the message header", qq(
<p align="right"><LOGIN_USER><br><PRIVATE_MSG_ALERT><LOCAL_USER_LIST><br><MSG_READERS></p>
)],
[msg_header=> "hidden", "", ""],
[msg_footer=> "hidden", "", ""],
[msg_template=> "htmltext", "rows=16 cols=48 wrap=soft", "Message template HTML(must contain macro PAGE_CONTENT", 
qq(<html>
<head>
<meta http-equiv="Expires" content="0">\n</head>
<body bgcolor="#ffffff">
PAGE_CONTENT
</body></html>)
],
[msg_sep1=>"textarea", "rows=4 cols=48", "Separator between TOP message bar and message body (TOPBAR_BODY_SEP)", ""],
[msg_sep2=>"textarea", "rows=4 cols=48", "Delimiter at the end of message body (MSGBODY_BBAR_SEP)", "<br>"],
[mbar_macros=>'const', "", "Available macros", join("<br>", @jW::mbar_tags, @jW::org_info_tags)],
[message_page_layout=>"htmltext", "rows=12 cols=48 wrap=soft", "Message content area template",
qq(
MSG_TOP_BAR TOPMBAR_BODY_SEP 
<table width="100%" cellpadding="3" cellspacing="1">
<tr><td bgcolor="#e5e5d1" width="20%" valign="top">
POST_BY_WORD: MSG_AUTHOR_STR<br>
AUTHOR_AVATAR<br>
MSG_DATE<br>
<hr size="1" noshade />
AUTHOR_PROFILE_LNK MAIL_USER_LNK EDIT_MSG_LNK<br>
</td><td valign="top">
MSG_BODY MSG_IMG MSG_ATTACHMENTS<br>
MSG_ATTACHED_OBJ<br>
MSG_ATTACHED_OBJ_MOD<br>
AUTHOR_SIGNATURE <br>MSG_RLNK <br>
MODIFIED_STR
</td></tr></table>
MSGBODY_BBAR_SEP
MSG_BOTTOM_BAR
)],
[message_attachment_layout=>"htmltext", "rows=4 cols=48 wrap=soft", "Message attachment layout (MSG_ATTACHMENTS)",
qq(<table border="1"><tr bgcolor="#aaaaaa"><th><font color="#ffffff">Uploaded file</font></th></tr><tr><td>UPLOADED_FILES</td></tr></table>)],
[iWz=>"checkbox", "value=1", "Add bottom navigation bar at the end of message", "1"],
[yXz=>"checkbox", "value=1", "Show simple rate form at the end of message", "0"],
[ySz=>"checkbox", "value=1", "Show link to current page at the end of message", "1"],
[show_user_profile=>"checkbox", "value=1", "Show link to user profile", "1"],

[jQ => "head", "Message Navigation Bars"], 
[orig_msg_str=>"textarea", qq(rows="8" cols="65" wrap="soft"), "Original message string (ORIG_MSG_STR)", qq(RE_WORD: MSG_REF_LNK -- MSG_AUTHOR_ORIG)],
[mbar_width => "text", "size=8",  "Width of the navigation bar inside message body (MBAR_WIDTH)", "100%"],
[bgmsgbar => "color", "size=48",  "Background color of navigation bar inside message (MBAR_BG)", "#e5e5d1"],
[zBz => "text", "size=48",  "Other attributes of the navigation bar table inside message body (MBAR_ATTRIB)", qq(cellpadding=0 cellspacing=0)],
[mbar_layout => "htmltext", qq(rows="8" cols="65" wrap="soft"), "Layout of the top navigation bar inside message (MSG_TOP_BAR)",
qq(<table MBAR_WIDTH MBAR_BG MBAR_ATTRIB>
<tr bgcolor="#006699">
<td colspan="2" align="center" width="70%"><font color="#e5e5d1">MSG_TITLE</font></td>
<td>MSG_MOOD_ICON</td><td align="right" valign="top"><img src="$abmain::img_top/curve_ur.gif" border="0"></td></tr>
<tr><td width="55%">ORIG_MSG_STR</td> 
<td align="center" width="12%">REPLY_MSG_LNK</td>
<td align="center" width="12%">TOP_MSG_LNK</td>
<td align="center" width="12%">FORUM_LNK</td></tr>
</table>
)],
[mbbar_layout => "htmltext", qq(rows="10" cols="65" wrap="soft"), "Layout of the bottom navigation bar inside message (MSG_BOTTOM_BAR)",
qq(<table MBAR_WIDTH MBAR_BG MBAR_ATTRIB>
<tr>
<td width="40%" align=left>REPLY_MSG_LNK | RECOMMEND_MSG_LNK | ALERT_ADM_LNK</td>
<td>RATE_MSG_LNK</td>
<td>
VIEW_ALL_LNK
WHERE_AMI_LNK
UP_MSG_LNK
TOP_MSG_LNK
</td>
<td align=right>
PREV_MSG_LNK | NEXT_MSG_LNK | CURRENT_PAGE_LNK
</td>
</tr>
</table>
)],

[btn_preview=>"submit", "value=Preview", "Click to preview", ""],
);
@abmain::tU=(
[text_info => "head", "Label Text"], 
[cat_word=>"text", "size=48", "Text for Message category", "Message category"],
[nt_word=>"text", "size=48", "Tag at the end of message subject for no content messages", "(no text)"],
[vEz => "text", "size=48", "Text for Recommend",  "Recommend"],
[alert_word => "text", "size=48", "Text for Alert",  "Alert"],
[reload_word => "text", "size=48", "Text for Reload",  "Reload"],
[reload_chat_word=> "text", "size=48", "Text for Refresh Chat",  "Refresh"],
[links_word => "text", "size=48", "Text for Links link",  "Links"],
[usercp_word => "text", "size=48", "Text for User Control Panel",  "User Panel"],
[tags_word => "text", "size=48", "Text for Tags link",  "Tags"],
[stats_word => "text", "size=48", "Text for posting stats link",  "Stats"],
[online_stats_word => "text", "size=48", "Text for who's online link",  "Who.."],
[online_users_lab => "text", "size=48", "Text for online users",  "Online users"],
[readers_lab => "text", "size=48", "Text for readers of a message",  "The following users have read the message:"],
[gochat_word => "text", "size=48", "Text for chat link",  "Chat"],
[survey_word => "text", "size=48", "Text for poll",  "Poll"],
[members_word => "text", "size=48", "Text for members",  "Members"],
[db_word => "text", "size=48", "Text for databases",  "Databases and Forms"],
[events_word => "text", "size=48", "Text for Events",  "Events"],
[uH=> "text", "size=48", "Label for Post Message. ( You can use IMG TAGS ) ",  "New Post"],
[post_form_word=> "text", "size=48", "Label for Post A Form. ( You can use IMG TAGS ) ",  "New Form Post"],
[uI => "text", "size=48", "Text for Post Reply",  "Post Reply"],
[edit_word => "text", "size=48", "Text for edit",  "Edit"],
[sK=> "text", "size=48", "Label for Register",  "Register"],
[fKz=> "text", "size=48", "Label for Login",  "Login"],
[logout_word=> "text", "size=48", "Label for Logout",  "Logout"],
[sJ=> "text", "size=48", "Text for Re",  "Re"],
[aPz=> "text", "size=48", "Text for Star used in rating",  "*"],
[required_word=> "text", "size=48", "Label to signify that a field is required",  qq(<font color="#cc0000"><sup>*</sup></font>)],
[notread_word=> "text", "size=48", "Text for New Private Msg",  " <font color=#00aa00>New</font>"],
[minus_word=> "text", "size=48", "Text for Minus used in rating",  "-"],
[zQ=> "text", "size=48", "Text for Rate",  "Rate"],
[gPz=>"text",  "size=48", "Label for registered user", q(<sup><small>&reg;</small></sup>)],
[kMz=>"text",  "size=48", "Label for Author profile", qq(Author Profile)],
[mail_word=>"text",  "size=48", "Label for Mail author", qq(Mail author)],
[bQz=>"text", "size=48", "Text for the label that indicates image presence", "<b><font color=red size=-1>img</font></b>"],
[attach_tag_word=>"text", "size=48", "Text for the label that indicates attachments", "<b><font color=red size=-1>file</font></b>"],
[lnk_tag_word=>"text", "size=48", "Text for the label that indicates link presence", "<b><font color=red size=-1>link</font></b>"],
[aUa=>"text", "size=48", "Text for the label that indicates message is collapsed", '<b><font color=red size=-1>more</font></b>'],
[sE => "text", "size=48", "String for Posted by",  "Posted by"],
[qN => "text", "size=48", "Text for post button",  " Post!"],
[continue_button_word => "text", "size=48", "Text for continue button",  " Continue"],
[qM => "text", "size=48", "Text for reset button",  " Reset"],
[rI => "text", "size=48", "Text for Submit",  " Submit!"],
[qT => "text", "size=48", "Text for Reset",  " Reset"],
[qC=> "text", "size=48", "Text for E-Mail label",  "E-Mail"],
[sH=> "text", "size=48", "Text for name label",  "Name"],
[to_word=> "text", "size=48", "Text for To label",  "Private Recipients (separate multiple names by comma)"],
[rW=> "text", "size=48", "Text for password label",  "Password"],
[rN=> "text", "size=48", "Text for subject",  "Topic"],
[mood_word=> "text", "size=48", "Text for Mood",  "Feeling"],
[rK=> "text", "size=48", "Text for message",  "Message"],
[rF=> "text", "size=48", "Text for message body",  qq(<br><center>M<br>E<br>S<br>S<br>A<br>G<br>E</center>)],
[rT => "text", "size=48", "Text for Link",  "Link "],
[read_more_word => "text", "size=48", "Text for Read more",  "more..."],
[qEz => "text", "size=48", "Text for Related link",  "Related link: "],
[rO=> "text", "size=48", "Text for URL",  "URL "],
[sD=> "text", "size=48", "Text for Title",  "Title"],
[sB=> "text", "size=48", "Text for Original",  "Original "],
[lJa=>"text", "size=48", "Text for reply options", "Reply options"],
[hRz=>"text", "size=48", "Text for notify author", "Notify original author"],
[hSz=>"text", "size=48", "Text for notify myself", "Notify me on response"],
[priv_reply_word=>"text", "size=48", "Text for reply private", "Private reply"],
[priv_reply_only_word=>"text", "size=48", "Text for all replies are private", "All replies are private"],
[hTz=>"text", "size=48", "Text for disallow replies to my message", "Disallow replies"],
[sC => "text", "size=48", "Text for Image",  "Image "],
[sortkey_word => "text", "size=48", "Text for sort key",  "Sort key"],
[keywords_word => "text", "size=48", "Text for sort key",  "Key words"],
[gQz => "text", "size=48", "Text for Upload",  "Attachment"],
[tF => "text", "size=48", "Text for main forum link",  "Forum"],
[qKz => "text", "size=48", "Text for forum archive link",  "Archive"],
[kRz => "text", "size=48", "Text for user private forum link",  "Private Msg"],
[qLa=>"htmltext", "rows=3 cols=48", "Text alerting about new private message", qq(<font color="#cc000">New private message</font>)],
[cp_word => "text", "size=48", "Text for current page link",  "Current page"],
[iVz => "text", "size=48", "Text for link to the original message",  "Original"],
[next_msg_word => "text", "size=48", "Text for link to the next message",  "Next"],
[prev_msg_word => "text", "size=48", "Text for link to the previous message",  "Previous"],
[top_word => "text", "size=48", "Text for link to the Top message",  "Top of thread"],
[where_ami_word => "text", "size=48", "Text for link to the Where am I page",  "Where am I?"],
[view_all_word=> "text", "size=48", "Text View All",  "View All"],
[jRz=> "text", "size=48", "Text for You were here ",  "<font size=+1 color=red>You were here!</font>"],
[tE=>"text", "size=48", "Text for link to earlier messages", "Previous"],
[back_word=>"text", "size=48", "Text for link to previous page", "Back"],
[tB=>"text", "size=48", "Text for overview", "Overview"],
[full_view_word=>"text", "size=48", "Text for Full View", "Full view"],
[tC=>"text", "size=48", "Text for Find", "Find"],
[gfind_word=>"text", "size=48", "Text for cross forum search", "Quick search"],
[tD=>"text", "size=48", "Text for Options", "Options"],
[tA=>"text", "size=48", "Text for newest message link", "Newest"],
[qE=>"htmltext", "rows=4 cols=48", "Text for Followups", qq(<p><table cellpadding=3 bgcolor="#e5e5d1" border="0" width=100%>\n<tr><td><font SIZE="2" FACE="Arial" color="#000000"><b>Replies to this message</b></td></tr></table><br>)],
[wV=>"text", "size=48", "Text for Admin", "Admin"],
[btn_preview=>"submit", "value=Preview", "Click to preview", ""],
);

#} #end of BEGIN

#sub wAz{

#BEGIN {

@abmain::root_login_cfgs=(
[rlinf=>"head", "Login AnyBoard Site Administration"],
[root_name => "text", 'size=40', "Master Admin Login ID", ""],
[root_passwd => "password", 'size=40', "Master Admin Password", ""],
[cmd=>"hidden", "", "", "loginroot"]
);
@abmain::del_news_cfgs=(
[rlinf=>"head", "Delete news"],
[newscat=> "text", 'size=40', "News category ID", ""],
[newsurl=> "text", 'size=40', "News URL", ""],
[cmd=>"hidden", "", "", "delnews"]
);

@abmain::dN =(
[create_info =>"head", "Create Master Administrator Login"], 
[aF => "text", 'size=40', "Master Admin Login ID ( master admin is the one who creates forums )", ""],
[oU => "password", 'size=40', "Master Admin Password", ""],
[bBz => "password", 'size=40', "Retype Password", ""],
#x1
#x1
#x1
[iGz=> "text", 'size=40', "License key", "", "AnyBoardIsTheBest"],
['-'=> "hidden", 'size=40'],
);

@abmain::iBa=(
[create_info =>"head", "Configure AnyBoard Lead Page And News"], 
[lead_header=> "textarea", 'rows=8 cols=48 wrap=soft', "Header of the lead page from &lt;html&gt;", qq(<html><body><p align="left" style="margin-left: 5%"><b>AnyBoard Powered Forums</b></p>)],
[lead_footer=> "textarea", 'rows=8 cols=48 wrap=soft', "Footer of the lead page ending with &lt;/html&gt;", qq(<p align=right style="margin-right: 5%"><a href="/">Back to Home Page</a></p></body></html>)],
[desc_bef=> "textarea", 'rows=4 cols=48 wrap=soft', "HTML code before forum description"],
[desc_af=> "textarea", 'rows=4 cols=48 wrap=soft', "HTML code after forum messages"],
[inc_last=> "checkbox", '1=Yes', "Include abstract of last topic from forums", "1"],
[news_word=> "text", 'size=40', "Label for forum news", "<b>Hot topics</b><br>"],
[inc_news=> "checkbox", '1=Yes', "Include news from forums", "1"],
[news_cols=> "text", 'size=4', "Number of news columns", "1"],
[news_cnt=> "text", 'size=4', "Number of news displayed", "5"],
[short_view=> "checkbox", '1=Yes', "Short view", "0"],
[add_border=> "checkbox", '1=Yes', "Add border to list table", "0"],
[fcatopt=>"textarea", "rows=8 cols=48", "Forum category choices, one per line, in the format index=label. Categories will be listed in ascending order of indexes.", "A=General Disucssions\nB=Support Question"],
[newscatopt=>"textarea", "rows=8 cols=48", "News category choices, one per line, in the format index=label. Categories will be listed in ascending order of indexes.", "=General news\nB=Press releases"],
[newsiconopt=>"textarea", "rows=8 cols=48", "News category leading icons, one per line, in the format index=icon_html.", "=<img src=/abicons/idea.gif>\nB=*"],
[newstabattr=> "color", "", "Attribute of the table that contains the news", qq(bgcolor="#99ccff")],
@abmain::forum_org_info_cfgs,
[cmd=>"hidden", "", "", "lOa"],
);

@abmain::gDa=(
[banner_info=>"head", "HTML Code"],
[banner_tit=>"text", "size=48", "Title of the banner", ""],
[banner_txt=>"textarea", "rows=16 cols=48 wrap=soft", "Text of the banner", ""],
[banner_id=>"hidden", "", "Banner id", ""],
[cmd=>"hidden", "", "", "mBa"],
);
@abmain::ab_code_cfgs=(
[banner_info=>"head", "Perl Code"],
[perlcode=>"textarea", "rows=16 cols=48 wrap=soft", "PERL code", ""],
[cmd=>"hidden", "", "", "mAa"],
);

@abmain::forum_grp_cfgs =(
[create_info =>"head", "Create a new forum group"], 
[fgrp_name=> "text", 'size=60', "Group name", ""],
[fgrp_id=> "text", 'size=60', "Group ID ( a unique identifier, no spaces, no special characters )", ""],
[fgrp_desc=> "textarea", 'rows=4 cols=48 wrap=soft', "Group description", ""],
[fgrp_admin=> "password", 'size=40', "Group administrator login ID", ""],
[fgrp_passwd => "password", 'size=40', "Password", ""],
[fgrp_passwd2 => "password", 'size=40', "Retype Password", ""],
);

@abmain::lQa =(
[root_info=>"head", "General Manager Info"], 
[root_name => "text", 'size=40', "Login", ""], 
[root_passwd => "password", 'size=40', "Password", ""], 
[cat_info=>"head", "Category Management"], 
[cat_dir=> "text", 'size=60', "Directory name", ""],
[cat_name=> "text", 'size=60', "Category name", ""],
[cat_sortkey=> "text", 'size=60', "Category sort key", "aaa"],
[cat_list=> "checkbox", 'value=1', "List forums in this category", "1"],
[cat_istop=> "checkbox", 'value=1', "This is a top category", "0"],
[cat_makeboard=> "checkbox", 'value=1', "Allow making boards here", "0"],
[cat_inherit=> "checkbox", 'value=1', "Inherit parent layout", "1"],
[cat_inhe_guide=> "checkbox", 'value=1', "Inherit parent guide", "1"],
[cat_intf=>"head", "HTML layout info"], 
[cat_header=>"textarea", "rows=4 cols=60 wrap=soft", "Category page header", qq(</head><body bgcolor="#ffffff">)],
[cat_sepx=>"textarea", "rows=4 cols=60 wrap=soft", "Separator below back links", qq(<hr size=1 noshade>)],
[cat_desc=>"htmltext", "rows=12 cols=60 wrap=soft", "Category description", ""],
[cat_news=>"htmltext", "rows=12 cols=60 wrap=soft", "News for this category", ""],
[cat_guide=>"htmltext", "rows=8 cols=60 wrap=soft", "Guide for this category", ""],
[cat_sub_head=>"text", "size=60", "Label for sub categories", "Categories"],
[cat_cr_forum_head=>"text", "size=60", "Label for create new forum", "Create New Forum For This Category"],
[cat_cr_cat_word=>"text", "size=60", "Label for create category", "Create category"],
[cat_mod_cat_word=>"text", "size=60", "Label for modify category", "Modify category"],
[cat_cr_f_word=>"text", "size=60", "Label for create forum", "Create new forum"],
[inc_last=> "checkbox", '1=Yes', "Include abstract of last topic from forums", "1"],
[cat_show_admin=> "checkbox", '1=Yes', "Show administrator of the listed forums", "1"],
[cat_view_cat_word=>"text", "size=60", "Label for view all categories", "View All Categories"],
[cat_footer=>"textarea", "rows=4 cols=60 wrap=soft", "HTML code at the end of page", "</body></html>"],
[cat_macros=>'const', "", "Available macros", join("<br>", @abmain::cat_tags)],
[cat_layout=>"htmltext", "rows=24 cols=60 wrap=soft", "Category body layout", 
qq!<table width=70% align=left border="0" cellpadding=3>
<tr>
<td bgcolor="#cccc99"><font size=+2>AB_CAT_NAME</font></td><td>
AB_CAT_DESC</td>
<td width="20%" rowspan=2 valign="top" bgcolor="#cccc99">
AB_CAT_GUIDE<br>
<hr>
AB_CREATE_FORUM_LNK<br>
AB_VIEW_CAT_LIST_LNK<br>
AB_CREATE_CAT_LNK<br>
AB_MODIFY_CAT_LNK<br>
</td>
</tr>
<tr><td valign=top bgcolor="#9999cc">
AB_SUB_CAT_LIST<br>
</td>
<td bgcolor="#FFFFee">
AB_CAT_NEWS
<hr noshade>
AB_CAT_FORUM_LIST
</td></tr>
</table>
!],
[btn_preview=>"submit", "value=Preview", "Click to preview", ""],
);

@abmain::kDz= (
[del_info=>"head", "Delete Forum"], 
[aF => "text", 'size=40', "Master Admin Login", ""],
[oU => "password", 'size=40', "Master Password", ""],
[forum_vpath =>"text", "size=40", "Forum Directory Name", "myboard"],
[hQz=> "checkbox", 'value=1', "Deleted forum cannot be recovered, are you sure that you want to delete the forum?", "0"],
);

$lEz=q(86474707a3f2f2e656472657c616e236f6d6f216e69726f6162746f2);
$lFz=q(86474707a3f2f216e69726f6162746e2e65647f2367696d22696e6f2c6f676f6f537e2367696);

$uE=pack("h*", $lEz);
$uF=pack("h*", $lFz);

@abmain::mSz=(
[loginfo =>"head", "Request password by email"], 
[kQ => "text", 'size=40', "Enter login id", ""],
[email=>"text", 'size=40', "Email address", ""]
);

@abmain::bO = (
[adm_info =>"head", "Modify Forum Administrator Login"], 
[admin => "text", 'size=20', "Admin Login", "admin"],
[admin_email => "text", 'size=40', "Admin E-mail Address. Make sure this is correct, so you can receive lost password", ""],
[oA => "password", 'maxlength=16', "Old Password", ""],
[mS => "password", 'maxlength="16"', "New Password", ""],
[dQz => "password", 'maxlength="16"', "Re-type New Password", ""],
[core_opts=>"hidden"],
);

$uJ=unpack("%16C*", $uE);

@abmain::vC = (
[mod_info =>"head", "Modify Forum Moderator Login"], 
[moderator => "text", 'size=20', "Moderator Name", "watcher"],
[moderator_email => "text", 'size=40', "Moderator E-mail Address", ""],
[vI => "password", 'maxlength=16', "Moderator Password", ""],
[vM => "checkbox", 'value=1', "Allow moderator to archive message", "1"],
[mod_can_dopoll=> "checkbox", 'value=1', "Allow moderator to manage polls", "1"],
[vN => "checkbox", 'value=1', "Allow moderator to delete user", "0"],
);

@abmain::vQ = (
["notify_info", "head", "Forum Notification Control"], 
[login_msg=> "htmltext", 'rows=4 cols=60 wrap=soft', "Message to display when user logins in", "Welcome back!"],
["post_welcome", "checkbox", "value=1", "Post a welcome message when a new user registers", "1"], 
[welcome_subjs=> "textarea", 'rows=4 cols=60 wrap=soft', "Subjects of the welcome message, one per line. AnyBoard will randomly select one", "Please welcome a new member {USERNAME}!\n We have a new member! Please welcome {USERNAME}\n"],
[welcome_cat=> "text", 'size=4', "Category <b>index</b> of the welcome message", ""],
[welcome_msg=> "htmltext", 'rows=4 cols=60 wrap=soft', "Content of the welcome message", "{USERNAME}, Hope you enjoy this forum!"],
[welcome_email=> "textarea", 'rows=4 cols=60 wrap=soft', "Additional email text sent to new user", ""],
#x1
["cc_author", "checkbox", "value=1", "E-mail the author a copy of his post", "0"], 
["xS", "checkbox", "value=1", "Let user decide whether to send notification ( if enabled )","0"], 
["bTz",  "text", 'size=60', "Message telling user choose notification admin", "Notify admin by e-mail"],
["iQz",  "text", 'size=60', "Message telling admin choose to notify all users", "Notify all users"],
["jAa",  "text", 'size=60', "Message telling admin choose to report", "Report"],
["xG", "checkbox", "value=1", "Include full message body in notification", "1"], 
["mJz", "checkbox", "value=1", "Remove HTML tags in message body", "0"], 
["wQ", "checkbox", "value=1", "Inform posters about notification email delivery status", "0"], 
["wN",  "text", 'size=60', "List of e-mail addresses to be notified, separated by comma", 'webmaster@your-domain.com'],
["iZa",  "text", 'size=60', "List of e-mail addresses to report by administrator, separated by comma", 'myboss@your-domain.com'],
#x1
["notifier",  "text", 'size=60', "E-mail address from which notification is sent. This is also used as the FROM address of validation email", 'webmaster@your-domain.com'],
["jBa",  "text", 'size=60', "Footer of the notification email", ''],
["dUz", "checkbox", "value=1", "Allow user to choose to receive e-mail notification of responses", "0"], 
["dWz", "checkbox", "value=1", "Allow responding author to send e-mail notification to original author", "1"], 
["cQz", "text", "size=60", "SMTP server for sending email ( override system setting )", ""],
)
;

@abmain::forum_mbox_cfgs=(
["info", "head", "Forum Mailbox"], 
[takepop=>'checkbox', "value=1", "Receive new posts from POP3 mailbox?", "0"],
[qFa=>"htext", "size=40", "POP3 server host name", ""],
[qCa=>"htext", "size=20", "POP3 user ID", ""],
[qDa=>"htext", "size=20", "POP3 user password", ""],
);

@abmain::forum_mailback_cfgs=(
["mailback_info", "head", "Forum mail back control"], 
#x1
["nTz", "checkbox", 'value=1', "Enable file distribution function for admin only", "1"],
[mZz=> "checkbox", "value=1", "Mail back only to e-mail addresses listed below", "0"], 
[nEz=> "textarea", 'rows=4 cols=60 wrap=soft', "Mail back only if e-mail address is one of the following ( list one per line )", ""],
[pHz=> "textarea", 'rows=4 cols=60 wrap=soft', "Message to e-mail back when user posts message", "Thank you!"],
[nAz=> "checkbox", "value=1", "Include full message body in mail back", "0"], 
[nJz=>  "text", 'size=40', "Fixed subject", ""],
)
;

@abmain::forum_chat_cfgs =(
[jQ => "head", "Chat Room Configuration"], 
[enable_chat =>"checkbox", "value=1", "Enable chat function", "1"], 
[hLa=>"checkbox", "value=1", "Show last message on top", "1"],
[tEz => "color", "", "Background color for the message area", "#ffffff"],
[yOz=> "textarea", 'rows=4 cols=60 wrap=soft', "HTML at the top of the message area", qq(
<style type="text/css">
DIV.CHATAREA { margin-left: 10px; margin-right:10px; background-color: #ffffff; }
</style>
)],
[yPz=> "textarea", 'rows=4 cols=60 wrap=soft', "HTML above the message list"],
[yQz=> "textarea", 'rows=4 cols=60 wrap=soft', "HTML below message list"],
[yNz=> "textarea", 'rows=4 cols=60 wrap=soft', "HTML at the bottom of the message area", ""],
[chat_cmd_bg => "color", "", "Background color for the input area", "#6699cc"],
[chat_usr_bg => "color", "", "Background color for the user list area", "#006699"],
[sOz => "text", "size=40", "Font attribute of the message text", qq($abmain::dfa color="#000000" size=1)],
[sVz => "text", "size=40", "Font attribute of the chat user name", qq($abmain::dfa color="#cc0000" size=1)],
[tDz => "text", "size=40", "Minimum refresh interval for the chat page in seconds (should be > 5)", "15"],
[tBz=> "text", "size=40", "Welcome message when a user enters", "USER_NAME entered the chat room, welcome!"],
[chat_sys_name => "text", "size=40", "Chat system name", "AnyBoard"],
[sZz=> "text", "size=40", "Notification message when a user leaves", "USER_NAME has left!"],
[sHz=> "text", "size=40", "Separator between user name and message", ": "],
[yMz=> "text", "size=40", "Separator between messages", ""],
[chat_mlen=> "text", "size=40", "Maximum length of a message", "80"],
[chat_max_age=> "text", "size=40", "Do not show messages older than this many seconds", "900"],
[chat_peek_msg=> "text", "size=40", "Message when a user peeks", "Someone is peeking at the door!"],
[chat_no_peek_msg =>"checkbox", "value=1", "Do not announce when someone is at the door", "1"],
[tCz=> "text", "size=40", "Number of messages to display", "20"],
[sFz=> "text", "size=40", "Height of the input frame", "100"],
[chat_usr_width=> "text", "size=40", "Width of the user list", "80"],
[tAz=>"text", "size=40", "Text for the Speak word",  "Speak"],
[tFz=>"text", "size=40", "Text for the Leave word",  "Leave"],
);

@abmain::uTz =(
[jQ => "head", "Event Calendar Configuration"], 
#x1
[uIz=>"checkbox", "value=1", "Allow users to add event", "1"],
[uSz=>"checkbox", "value=1", "Users must be registered to add event", "0"],
[uKz=>"textrea", "rows=3 cols=60", "Attribute of the table enclosing the event detail", qq(border=3 bgcolor=#ffffcc cellspacing=0 cellpadding=5 width=70%)],
[uQz=> "color", "size=48",  "Background color of an event attribute", "#dddddd"],
[uRz=> "color", "size=48",  "Background color of next event attribute", "#ffffff"],
[eve_add_word=>"text", "size=60", "Add event label", "Add new event"],
[tNz=>"text", "size=60", "Event Time label", "Time"],
[uJz=>"text", "size=60", "Event location label", "Location"],
[uDz=>"text", "size=60", "Event status label", "Status"],
[uUz=>"text", "size=60", "Event description label", "Activity"],
[uVz=>"text", "size=60", "Event organizer", "Coordinator"],
[uCz=>"text", "size=60", "Contact information label", "Contact info"],
[uGz=>"textarea", "rows=3 cols=60 wrap=soft", "Event list label", "<h4><center>Event List</center></h4>"],
[uXz=>"textarea", "rows=3 cols=60 wrap=soft", "Event details label", "<center><h4>Event details</h4></center>"],
[uLz=>"textarea", "rows=3 cols=60 wrap=soft", "Separator between event details", "<hr width=50%>"],
[eve_page_top_banner=>"textarea", "rows=6 cols=60 wrap=soft", "Event page top banner"],
[eve_page_bottom_banner=>"textarea", "rows=6 cols=60 wrap=soft", "Event page bottom banner", ""],
);
@abmain::group_idx_cfgs =(
[jQ => "head", "Group index page Configuration"], 
[enable_grp_intf=>"checkbox", "value=1", "Enable group interface", "1"], 
[idx_fset_attr =>"textarea", "rows=3 cols=48 wrap=soft", "Frame set attribute", qq(rows="50,*" border="0" marginwidth=0)],
[idx_tframe_attr =>"textarea", "rows=3 cols=48 wrap=soft", "Top frame attribute", qq(border="0" marginwidth=0)],
[idx_bframe_attr =>"textarea", "rows=3 cols=48 wrap=soft", "Bottom frame attribute", qq(border="0" marginwidth=0)],
[idx_tframe_head =>"textarea", "rows=6 cols=48 wrap=soft", "Header HTML of the top frame", qq(<html><body bgcolor="#ffffff" style="margin-top: 0; font-size: 10pt">)],
[idx_macros=>'const', "", "Available macros", join("<br>", @jW::idx_tags)],
[idx_nav_cfg =>"htmltext", "rows=8 cols=48 wrap=soft", "Group navigation configuration",
qq(<table border="0" cellspacing=0 cellpadding=5 bgcolor="#cccccc" width="100%" align=left><tr>
<td bgcolor="#ffffff"><b>FORUMNAME</b></td>
<td>MEMBERLNK</td><td>STATSLNK</td><td>REGLNK</td><td>LOGINLNK</td>
<td>MAINLNK</td><td>ARCHLNK</td><td>CHATLNK</td><td>SURVEYLNK</td>
<td> EVELNK </td>
<td> LINKSLNK </td>
<td>MYFORUMLNK</td><td bgcolor="#99ddff">ADMLNK</td>
</tr></table>
)
],
[idx_tframe_foot =>"textarea", "rows=6 cols=48 wrap=soft", "Footer HTML of the top frame", qq(</body></html>)],
);

@abmain::forum_bar_cfgs=(
[jQ => "head", "Forum Navigation Bars"], 
[gUa=>'const', "", "Available macros", join("<br>", @jW::gLa)],
[navbar_layout=> "textarea", "rows=8 cols=48 wrap=soft", "Layout of the navigation bar ( do not change this unless you are sure )", 
qq(<td align="center">GOPAGEBTN</td><td align="center">POSTLNK</td><td align="center">FINDLNK</td>
 <td align="center">TAGSLNK</td><td align="center">PREVLNK</td><td align="center">CHATLNK</td><td align="center">NEWESTLNK</td><td>ARCHLNK</td>
 <td align="center">REGLNK </td><td>LOGINLNK</td><td align="center">USERCPANELLINK</td><td align="center">OVERVIEWLNK</td><td align="center">DBLNK</td><td align="center">ADMLNK</td>)],
[navbar_ul=> "textarea", "rows=2 cols=48 wrap=soft", "Upper left TD of the navigation bar" ], 
[navbar_ur=> "textarea", "rows=2 cols=48 wrap=soft", "Upper right TD of the navigation bar" ], 
[navbar_bl=> "textarea", "rows=2 cols=48 wrap=soft", "Bottom left TD of the navigation bar", qq(<td valign=bottom align=left><img src="$abmain::img_top/curve_ll.gif"></td>)], 
[navbar_br=> "textarea", "rows=2 cols=48 wrap=soft", "Bottom right TD of the navigation bar", qq(<td valign=bottom align=right><img src="$abmain::img_top/curve_lr.gif"></td>)], 
[navbar_layouta=> "textarea", "rows=8 cols=48 wrap=soft", "Layout of the navigation bar for archived pages", q(<td>GOPAGEBTN</td><td>FINDLNK OVERVIEWLNK PREVLNK</td><td>NEWESTLNK MAINLNK</td>)],
[gobtn_url=> "text", "size=60", "URL of the go button on navigation bar", ""], 
#x1
[dBz=>"checkbox", "value=1", "Show forum name on nav bar", "0"],
[navbarbg => "color", "size=48",  "Background color of the navigation bar", "#5a76a5"],
[navbarattr => "text", "size=48",  "Other table attributes of the navigation bar", qq(border="0" cellspacing="0" class="NAV")],
[nNz => "color", "size=48",  "Background color of the navigation bar on archive page", "#99ccff"],
[navbdsize => "text", "",  "Width of the border around navigation bar", "0"],
[navbdcolor => "color", "size=48",  "Color of the navigation bar border", "#999988"],
[navbdpad => "text", "",  "Space around content in navigation bar", "0"],
);

@abmain::forum_return_cfgs=(
[text_info => "head", "Post confirmation configuration"], 
[return_header=> "textarea", "rows=8 cols=48", "HTML header for the post confirm page, start from \&lt;/head\&gt;\&lt;body\&gt;", qq(</head><body bgcolor="#ffffff">)],
[return_footer=> "textarea", "rows=8 cols=48", "HTML footer for the post confirm page, end with &lt;/body&gt;&lt;/html&gt;", qq(</body></html>)],
[pc_hcolor => "text", "size=48", "Color of the heading on confirmation page",  "#006699"],
[pc_thx => "text", "size=48", "Text for Thank you",  "Thank you, "],
[pc_msg=> "text", "size=48", "Message to confirm post is added ",  "Your Message Has Been Added To "],
[pc_banner=> "textarea", "rows=4 cols=48", "Banner on confirmation page",  ""],
[pc_msg2=> "text", "size=48", "Informational message if moderation is off",  "You need to reload the main forum page to see your post!"],
[pc_msg2_moder=> "text", "size=48", "Informational message if pre-moderation is on",  "Your message has been submitted for review!"],
[pc_goto => "text", "size=48", "Text for Go to message",  "Go To Your message"],
[pc_edit => "text", "size=48", "Text for Edit message",  "Edit Your message"],
[pc_date => "text", "size=48", "Text for Added on date",  "Added on date"],
[pc_header => "text", "size=48", "Header for message information",  "<font color=#ffffff>The following is the information about your message</font>"],
[pc_advise => "text", "size=48", "Final advice",  "Please do not post the same message again."],
);
@abmain::qSz=(
[jQ => "head", "Add or Modify Poll"], 
[qQz=>"text", "size=16", "ID for the poll (no spaces)", ""],
[rFz=>"text", "size=48", "Poll question", "", undef, qq(<font color=#ffffff>How do you like Anyboard?</font>)],
[qRz=>"textarea", "rows=6 cols=48", "Poll choices, one per line, in the format index=answer","", undef, "1=Very much\n2=Very very much\n3=It is the best!"],
[fVa=>"checkbox", "value=1", "Make this a multiple choice poll", "0"],
[jQ => "head", "Optional Display Settings"], 
[polltabattr=>"text", "size=48", "Attribute of the table that encloses the poll form", "", undef, qq(border="0" cellspacing=1 bgcolor="#e5e5d1")],
[pollrtabattr=>"text", "size=48", "Attribute of the table that encloses the poll result", "", undef, qq(border="0" cellspacing=1 bgcolor="#e5e5d1")],
[pollhbg=>"color", "size=48", "Background color of the title", "", undef, "#006699"],
[rNz=>"color", "size=48", "Color of the proportional block", "", undef, "red"],
[pollvoteword=>"text", "size=48", "Label for the vote button", "", undef, "Vote"],
[jQ => "head", "Optional Control Settings"], 
[rEz=>"checkbox", "value=1", "User must logon to vote", "0"],
[qVz=>"checkbox", "value=1", "Log domain information", "0"],
[rIz=>"checkbox", "value=1", "Reject vote if domain reverse lookup fails", "0"],
[qWz=>"checkbox", "value=1", "Reject duplicate votes from same IP", "1"],
[rBz=>"checkbox", "value=1", "Inactivate this poll", "0"],
[polllisted=>"checkbox", "value=1", "List this poll on poll index page (poll/index.html)", "1"],
[rDz=>"checkbox", "value=1", "Check to confirm overwriting existing poll", "0"],
);
$abmain::lRz = qq(<script LANGUAGE="JavaScript1.1">\n<!--\n);
$abmain::js_end = qq(//-->\n</script>\n);

$abmain::kSz = <<'COOKIE_JS',

function mMz()
{
 var mPz = "";
 for(var prop in this) {
 if ((prop.charAt(0) == '_' && prop.charAt(prop.length-1)=='_')
		      || ((typeof this[prop]) == 'function')) 
 continue;
 if (mPz != "") mPz += '&';
 mPz += prop + ':' + escape(this[prop]);
 }
 var cookie = this.gHa + '=' + mPz;
 if (this._expiration_)
 cookie += '; expires=' + this._expiration_.toGMTString();
 if (this._path_) cookie += '; path=' + this._path_;
 if (this._domain_) cookie += '; domain=' + this._domain_;
 if (this._secure_) cookie += '; secure';
 
 this._document_.cookie = cookie;
}

function mQz()
{
 var mOz = this._document_.cookie;
 if (mOz == "") return false;
 
 var start = mOz.indexOf(this.gHa + '=');
 if (start == -1) return false;   
 start += this.gHa.length + 1;  
 var end = mOz.indexOf(';', start);
 if (end == -1) end = mOz.length;
 var mPz = mOz.substring(start, end);

 var a = mPz.split('&'); 
 for(var i=0; i < a.length; i++)  
 a[i] = a[i].split(':');

 for(var i = 0; i < a.length; i++) {
 this[a[i][0]] = unescape(a[i][1]);
 }
 return true;
}

function Cookie(document, name, hours, path, domain, secure)
{
 this._document_ = document;
 this.gHa = name;
 if (hours)
 this._expiration_ = new Date((new Date()).getTime() + hours*3600000);
 else this._expiration_ = null;
 if (path) this._path_ = path; else this._path_ = null;
 if (domain) this._domain_ = domain; else this._domain_ = null;
 if (secure) this._secure_ = true; else this._secure_ = false;
 this.store = mMz;
 this.load = mQz;
}

COOKIE_JS
@abmain::bB = (
[cF =>"head", "User Registration Information"], 
[kQ => "text", 'size=40', "User login you wish to use", ""],
[email    => "text", 'size=40', "E-Mail", ""],
[wO => "text", 'size=40', "Home Page URL", "http://"],
[wJ=>"text", 'size=40 maxlength=32', "Where are you", ""],
[xK=>"text", 'size=40 maxlength=60', "One sentence about yourself, interests, experience, etc.", ""],
[nC => "password", 'size=40', "Password", ""],
[bD => "password", 'size="40"', "Retype Password", ""],
[noshowmeonline=>"checkbox", 'value=1',  "Do not let others know if you are in the forum", "0"], 
[add2notifiee =>"checkbox", 'value=1',  "Receive new posts in email", "0"], 
);
 
@abmain::mailer_cfgs=(
[sm_info=>"head", "AnyBoard Mailer"],
[from=>"const", "size=32", "Sender"],
[to=>"text", "size=32", "Recipient"],
[subject=>"text", "size=40", "Subject"],
[message=>"textarea", "rows=6 cols=50", "Message"],
[attachment=>"file", "size=10", "Attachment"],
[bccself=>"checkbox", "1=Yes",  "Bcc Self?"],
[cmd=>"hidden", "", "", "mailusr"],
);
@abmain::member_profile_cfgs = (
[mp_info =>"head", "Member Profile Information"], 
[realname=> "text", 'size=40', "Real Name (First, Last)", ""],
[company=> "text", 'size=40', "Company name", ""],
[email=>"hidden", "", "", ""],
[homepageurl=> "text", 'size=48', "Home page URL", "http://"],
[day_phone=> "text", 'size=20', "Day time phone number", ""],
[night_phone=> "text", 'size=20', "Night time phone number", ""],
[fax=> "text", 'size=20', "Fax number", ""],
[icqnumber=> "text", 'size=40', "ICQ Number", ""],
[icqnick=> "text", 'size=40', "ICQ Nickname", ""],
[address=> "textarea", 'rows=5 cols=60 wrap=soft', "Address", ""],
[gender=>'select', [male=>'Male', female=>'Female'], "Gender", ""],
[birthmonth=>'select', [map {$_, $_} @abmain::months], "Birth month", ""],
[birthday=>'select', [map {$_, sprintf("%02d", $_)} 1..31], "Birth day", ""],
[birthplace=> "text", 'size=40', "Birth place", ""],
[nationality=> "text", 'size=40', "Nationality", ""],
[agerange=>'select', [map { $_."0s", "${_}0-${_}9"} 0..15], "Age", "---"],
[occupation=> "text", 'size=40', "Occupation", ""],
[photourl=> "imgurl", 'size=40', "Photo URL", "http://"],
[photofile=> "file", 'size=40', "Photo image (upload file)", ""],
[avatar =>"radio", "", "Avatar", ""],
[signature=> "htmltext", 'rows=4 cols=60 wrap=soft', "Signature HTML code which will be appended to messages", ""],
[mystatement=> "htmltext", 'rows=12 cols=60 wrap=soft', "Free form personal statement (HTML allowed)", ""],
[ig_info =>"head", "Forum preferences"], 
[ignores=> "textarea", 'rows=5 cols=60 wrap=soft', "List of ignored users, separated by new line or |", ""],
#x2
[hG=>"text", "size=2", "Depth of links on main page", ""],
[yVz => "select", [%thread_sorters], "Sort threads by", ""],
[revlist_topic => "checkbox", '1=Yes', "List threads in ascending order ( older thread on TOP if time is used for sorting )", ""],
[revlist_reply => "checkbox", '1=Yes', "List old replies first", "1"],
[align_col_new=>"checkbox", "1=Yes", "Align message attributes in columns", ""],
[iW => "text", 'size="4"', "Number of message links per page", ""],
[userid=>"hidden", "", "", ""],
[cmd=>"hidden", "", "", "modmp"],
);

@abmain::mp_page_cfgs =(
[mp_ctrl_info=>"head", "Member Profile Page Configuration"], 
[mp_enabled=> "checkbox", 'value=1', "Enable extended member profile", "1"],
[mp_url=> "text", 'size=50', "Redirect user to this URL for profile submission ", ""],
[pstat_in_reginfo=> "checkbox", 'value=1', "Include posting stats in registration information page", "1"],
[mp_in_reginfo=> "checkbox", 'value=1', "Include extended profile in registration information page", "1"],
[mp_symbols=>'const', "", "Available variables", "<b>".join(' &nbsp;&nbsp;', "MEMBER_PIC", map{ "{".$_->[0]."}" } @abmain::member_profile_cfgs[1..21])."</b>"],
[mp_reqfields=>"textarea", "rows=2 cols=60 wrap=soft", "Required fields for extended profile", "realname company"],
[mp_skipfields=>"textarea", "rows=3 cols=60 wrap=soft", "Skipped fields for extended profile", "icqnumber icqnick address photourl nationality homepageurl fax night_phone gender birthmonth birthday birthplace photourl"],
[mplayout=> "htmltext", 'rows=20 cols=60 wrap=soft', "Layout of the extended profile",qq! 
<center>MEMBER_PIC
<br>
{realname} ( {userid} )
</center>
<table width=85% align="center" border=1 cellspacing=0 cellpadding=3>
<tr><th colspan=6 bgcolor="#eeeeee">Personal profile</th></tr>
<tr>
<td>Gender</td><td>{gender}</td>
<td>Birthday</td><td>{birthmonth} {birthday}</td>
<td>Age range</td><td>{agerange}</td>
</tr>
<tr>
<td>Nationality</td><td>{nationality}</td>
<td>Birth place</td><td>{birthplace}</td>
<td></td>
</tr>
<tr><th colspan=6 bgcolor="#eeeeee"><br>Contact information</th></tr>
<tr>
<td>Company</td><td>{company}</td>
<td>Occupation</td><td>{occupation}</td>
<td>Address</td><td>{address}</td>
</tr>
<tr>
<td>E-mail</td><td>{email}</td>
<td>ICQ Number</td><td>{icqnumber}</td>
<td>ICQ Nick</td><td>{icqnick}</td>
</tr>
<tr>
<td>Day phone</td><td>{day_phone}</td>
<td>Night phone</td><td>{night_phone}</td>
<td>Fax</td><td>{fax}</td>
</tr>
<tr><th colspan=6 bgcolor="#eeeeee"><br>Personal statement</th></tr>
<tr><td colspan=6 bgcolor="#ffffee">
{mystatement}
</td>
</tr>
</table>
!
],
[mpformlayout=> "textarea", 'rows=10 cols=60 wrap=soft', "Layout of the profile input form", ""],
[mpheader=> "textarea", 'rows=8 cols=60 wrap=soft', "Header HTML code starting from &lt;/head&gt;&lt;body&gt;", "</head><body>"],
[mpfooter=> "textarea", 'rows=8 cols=60 wrap=soft', "Footer HTML code ending with &lt;/body&gt;&lt;/html&gt;", "</body></html>"],
);
 
@abmain::gS = (
[create_info =>"head", "Master Administrator Login Info"], 
[aF => "text", 'size=40', "Master Admin Login", ""], 
[oU => "password", 'size=40', "Master Password", ""], 
[iGz=> "text", 'size=40', "License key", ""], 
[create_info =>"head", "New Forum Info"], 
[dQ =>"text", "size=40", "Name of the new forum", "",  "My Anyboard Forum"],
[wR =>"text", "size=40", "Forum virtual directory name", "", "anyboard9/forum"],
[new_forum_agree=> "checkbox", 'value=1', qq(I have read and agree to the <a href="$rules_url">license terms</a>), "0"],
[hU => "text", 'size=40', "New Forum Administrator's Login ID", "admin"],
[admin_email => "text", 'size=40', "Admin E-mail Address, must be valid", ""],
[admin_email2 => "text", 'size=40', "Retype Admin E-mail Address", ""],
);

@abmain::tM = (
[find_info =>"head", "Search Messages In Forum"], 
[tK=> "text", 'maxlength=40', "Search pattern separated by space.<br><small>If you want to search a single word, simply enter the word. To match multiple words, enter the words separated by spaces.</small>", ""],
[scat => "select", '', "Message category", ""],
[wT=> "checkbox", 'value=1', "Search in message body. ( If this is not checked, then only the message subject and author are used in the search)", "0"],
[yVz => "select", $thread_sort_sel, "Sort threads by", "mM"],
[aO=> "checkbox", 'value=1', "Include contents of all messages in result ", "0"],
[hKz=> "checkbox", 'value=1', "Match only those messages that contain images", "0"],
[find_range=> "const", '', "Posting day range (1 hour ~ 0.04 day)", "",  qq(From <input type="text" size=4 name="hIz" value="30"> days ago, to <input type="text" size=4 name="hJz" value=0> days ago.)],
);

@abmain::lFa= (
[iGz=> "text", 'maxlength=800', "Key", ""],
[cmd=>"hidden", "", "", "kOa"],
);

@abmain::tJz = (
[activate_info =>"head", "Activate Your Account"], 
[uname=> "text", 'maxlength=40', "User name", ""],
[vkey=> "text", 'maxlength=40', "Validation key", ""],
);

@abmain::del_conf_cfgs = (
[activate_info =>"head", "Please confirm operation"], 
[kIz=> "checkbox", 'value=1', "Confirm by checking the box and then submit", "0"],
);
@abmain::hPa = (
[hdr_info =>"head", "Recommend the page to a friend"], 
[re_subject=>"const", "", "Subject", ""], 
[friend_name=> "text", 'size=60', "Name of the friend", ""],
[friend_email=> "text", 'size=60', "Email address of the friend", ""],
[myname => "text", 'size=60', "Your name", ""],
[mycomments=> "textarea", 'rows=3 cols=60 wrap=soft', "Your comments", ""],
);

@abmain::gEa = (
[hdr_info =>"head", "Send an email"], 
[em_subject=>"text", "size=60", "Subject", ""], 
[em_emails=> "text", 'size=60', "Send to email boxes", ""],
[em_all=>"checkbox", "value=1", "Check to send to all users", "0"],
[myname => "text", 'size=60', "Your name", ""],
[myemail=> "text", 'size=60', "Your E-Mail", ""],
[mycomments=> "textarea", 'rows=3 cols=60 wrap=soft', "Your comments", ""],
);

@abmain::gZa = (
[hdr_info =>"head", "Alert admin about the page"], 
[re_subject=>"const", "", "Topic", ""], 
[comments=> "textarea", 'rows=3 cols=60 wrap=soft', "Your comments", ""],
);

@abmain::uHz = (
[eve_info =>"head", "Add An Event"], 
[eve_subject=> "text", 'size=60', "Subject of the event", ""],
[eve_start=> "time", '', "Start time", "" ],
[eve_end=> "time", '', "End time", "" ],
[eve_location=> "textarea", 'rows=4 cols=60', "Location", ""],
[eve_description=> "htmltext", 'rows=4 cols=60', "Description", ""],
[eve_status=> "textarea", 'rows=2 cols=60 wrap=soft', "Event status", ""],
[eve_org=> "text", 'size=60', "Event organizer", ""],
[eve_contact => "textarea", 'rows=4 cols=60', "Contact information", ""],
[eve_can_sign=> "checkbox", '1=Yes', "Allow users to sign up for this event", "1"],
[eve_author=> "hidden", '', "", ""],
);

@abmain::uMz =(
[jQ => "head", "Links Configuration"], 
[enable_links=>"checkbox", "value=1", "Enable link submission function", "1"],
[lnk_usr_add=>"checkbox", "value=1", "Allow users to add links", "1"],
[lnk_opt=>"textarea", "rows=16 cols=48", "Link category choices, one per line, in the format index=label. Categories will be listed in ascending order of indexes.","", undef, "=Select Category\n1=AnyEMail\n2=AnyBoard\n3=AnyECard"],
[lnk_usr_must_reg=>"checkbox", "value=1", "Users must be registered to add links", "0"],
[lnk_show_adm=>"checkbox", "value=1", "Display admin command on links page", "0"],
[lnk_max_desc=>"text", "size=60", "Maximum size of the link description", "512"],
[lnk_page_banner=>"textarea", "rows=6 cols=60 wrap=soft", "Link page top banner", "<h1>Related links</h1>"],
[lnk_vsep=>"textarea", "rows=6 cols=60 wrap=soft", "Separator above links", "<hr><br>"],
[lnk_page_bbanner=>"textarea", "rows=6 cols=60 wrap=soft", "Link page bottom banner", "<hr>"],
[lnk_add_word=>"text", "size=60", "Add link word", "Add a new link"],
[lnk_del_word=>"text", "size=60", "Delete link word", "<small>Delete</small>"],
[lnk_adm_word=>"text", "size=60", "Administer link word", "<small>Admin</small>"],
[lnk_sd_sep =>"text", "size=60", "Separator between link title and description", "\&nbsp;-\&nbsp;"],
);

@abmain::uWz = (
[lnk_info =>"head", "Add A Link"], 
[lnk_subject=> "text", 'size=60', "Title of the link", ""],
[lnk_url=> "text", 'size=60', "URL", ""],
[lnk_description=> "textarea", 'rows=3 cols=60', "Brief description", ""],
[lnk_author=> "hidden", '', "", ""],
);

@abmain::commit_cfgs = (
[commit_info =>"head", "Sign up"], 
[commit_contact=> "textarea", 'rows=2 cols=60 maxlength=240', "Your Contact information", ""],
[commit_comment=> "textarea", 'rows=2 cols=60 maxlength=120', "Comments", ""],
);

@abmain::forum_cfg_list = qw(
xO 
forginfo
yC 
fpost 
zE 
fmsg
ftag
bfeel
freturn
fbar 
fcolor
ffont
yE
lBz
fcat
ffm
ferror
yI
fmbox
fgrp 
fmp
fmailback
fchat
feve 
flnk
);

%abmain::qJa =(
yC=>["Control", \@abmain::eT, 1],
fpost=>["Posting Policy", \@abmain::tL, 1],
zE=>["Presentation", \@abmain::tG, 1],
fmsg=>["Message Page", \@abmain::forum_msg_cfgs, 1],
ftag=>["Tags transformation ", \@abmain::forum_tag_cfgs, 1],
fbar => ["Navigation bar",\@abmain::forum_bar_cfgs, 1],
#x1
#x1
fcolor=>["Colors", \@abmain::forum_color_cfgs, 1],
bfeel=>["Style", \@abmain::forum_style_cfgs, 1],
yE=>["Label", \@abmain::tU, 1],
ffont=>["Fonts", \@abmain::eWz, 1],
ferror=>["Error", \@abmain::error_cfg, 1],
freturn=>["Confirmation", \@abmain::forum_return_cfgs, 1],
fchat=>["Chat", \@abmain::forum_chat_cfgs, 1],
lBz=>["Emotion icons", \@abmain::lAz, 1],
#x1
#x1
#x1
#x1
);

%abmain::gRz =(
xO=>["Name", \@abmain::rC, 1],
forginfo=>["Name", \@abmain::forum_org_info_cfgs, 1],
yI=>["Notification", \@abmain::vQ, 0],
#x1
#x1
);

$uG=2654;
%abmain::eO =(
xO=>["Name and File", \@abmain::rC, 1],
forginfo=>["Organization Info", \@abmain::forum_org_info_cfgs, 1],
yC=>["Control", \@abmain::eT, 1],
fpost=>["Posting Policy", \@abmain::tL, 1],
zE=>["Presentation", \@abmain::tG, 1],
bfeel=>["Style", \@abmain::forum_style_cfgs, 1],
fmsg=>["Message Page", \@abmain::forum_msg_cfgs, 1],
#x1
#x1
freturn=>["Confirmation", \@abmain::forum_return_cfgs, 1],
#x1
ferror=>["Error", \@abmain::error_cfg, 1],
fbar => ["Navigation bar",\@abmain::forum_bar_cfgs, 1],
fcolor=>["Colors", \@abmain::forum_color_cfgs, 1],
ffont=>["Fonts", \@abmain::eWz, 1],
lBz=>["Emotion icons", \@abmain::lAz, 1],
yE=>["Label", \@abmain::tU, 1],
ftag=>["Tags transformation ", \@abmain::forum_tag_cfgs, 1],
#x1
yI=>["Notification", \@abmain::vQ, 0],
#x1
fchat=>["Chat", \@abmain::forum_chat_cfgs, 1],
#x1
#x1
ffm=>["Form Mail", \@abmain::cRa, 1],
);

%abmain::bK = (
 delnewsform=>['BOTH', \&pVa],
 delnews=>['BOTH', \&mKa],
 listnews=>['BOTH', \&fXaA],
 nI=> ['BOTH', \&gH, 'ADM'],
 hOz=> ['BOTH', \&hMz, 'ADM'],
 searchfs =>['BOTH', \&qMa],
 lGz=> ['BOTH', \&lHz, 'ADM'], 
 list_cats=> ['BOTH', \&wOz, 'ADM'], 
 cFz=> ['BOTH', \&cEz, 'ADM'], 
 log =>['POST', \&mN],
 login =>['POST', \&iQ],
 admlogout =>['POST', \&yFz],
 admin=>['GET', \&fBa],
 loginroot=>['POST', \&eYa],
 gochat =>['POST', \&sKz],
 sRz =>['POST', \&sWz],
 sQz =>['POST', \&vZz],
 speak=>['POST', \&sUz],
 fetchu=>["GET", \&pMa], 
 fetch_urls=>["GET", \&gJa],
#x1
 bRa=>['GET', \&bRa],
#x2
#x2
 hMa=>['GET', \&gQa],
 dW =>['POST', \&bP],
 bH =>['POST', \&oW],
 ulogout =>['POST', \&gIa],
 reqpassform=>['GET', \&mVz],
 reqpass=>['POST', \&mUz],
 form =>['BOTH', \&iO],
 follow =>['BOTH', \&fP],
 fU =>['POST', \&hQ, 'ADM'], 
 config =>['POST', \&cV, 'ADM'], 
 subs_config =>['POST', \&qUa, 'ADM'], 
 kHz =>['POST', \&kJz, 'ADM'], 
 cU =>['POST', \&iI, 'ADM'], 
 preview_cfg =>['POST', \&vSz, 'ADM'], 
 save_config =>['POST', \&mIz, 'ADM'], 
 rHz=>['POST', \&xOz, 'ADM'], 
 rCz=>['POST', \&rCz, 'ADM'],
 rVz=>['POST', \&rVz, 'ADM'], 
 rWz=>['POST', \&rWz, 'ADM'], 
 vote=>['POST', \&rGz, 'ADM'], 
 xLz=>['POST', \&xLz, 'ADM'], 
 sA =>['POST', \&hT],
 lF => ['POST', \&nU, 'ADM'], 
 vJz=>['GET', \&vJz],
 nOz => ['POST', \&nMz, 'ADM'],  
#x1
#x1
#x1
#x1
#x1
#x1
 dT => ['POST', \&bJ, 'ADM'], 
 hZz => ['GET', \&hZz, 'ADM'], 
 sinfo => ['GET', \&wLz, 'ADM'], 
 getpathinfo => ['GET', \&dJaA, 'ADM'], 
 iFz => ['GET', \&iFz, 'ADM'], 
 kPz=>['GET', \&kLz],
 uS => ['POST', \&wE, 'ADM'], 
 bSz => ['POST', \&aHz, 'ADM'], 
 vXz => ['GET', \&vXz], 
 tVz => ['GET', \&tVz], 
 wMz => ['GET', \&wMz], 
 gidx => ['GET', \&tMz], 
 tOz => ['GET', \&uAz], 
 jB => ['GET', \&oL], 
 vJ => ['GET', \&uO], 
 lKa =>['GET', \&lKa],
#x1
 iLz =>['POST', \&wSz, 'ADM'],
 uP=> ['GET', \&uK], 
 zG => ['GET', \&yS], 
 upload => ['POST', \&mGz], 
#x1
 bRz => ['GET', \&aEz], 
 bV => ['POST', \&uR],
 vG => ['POST', \&uU],
 yV => ['BOTH', \&lK], 
#x1
 admregform => ['BOTH', \&wHz], 
 delregform => ['BOTH', \&yEz], 
 qL => ['BOTH', \&oT],
 vFz => ['BOTH', \&wEz],
 mailform=> ['BOTH', \&nQa],
 mailusr=> ['BOTH', \&sQa],
 alertadmform => ['BOTH', \&gMa], 
 alertadm => ['BOTH', \&hVa],
 recommend => ['BOTH', \&xBz],
 eveform => ['BOTH', \&tWz],
 uNz => ['BOTH', \&wWz],
 tIz => ['BOTH', \&vIz],
 modeveform => ['BOTH', \&tKz],
 tZz => ['BOTH', \&tRz],
 addlnk => ['BOTH', \&uPz],
 uOz => ['BOTH', \&uFz],
 tUz => ['BOTH', \&wVz],
 tQz => ['BOTH', \&tLz],
 tTz => ['BOTH', \&wXz],
 tYz=>['BOTH', \&tSz],
 tXz=>['BOTH', \&xPz],
 vsl=>['BOTH', \&wIz],
 rA => ['BOTH', \&gG],
 zT => ['BOTH', \&aBz],
 zJ => ['BOTH', \&zO], 
#x1
#x1
#x1
 lLa=> ['BOTH', \&bHz], 
 init=> ['BOTH', \&gT],
 rinit=> ['BOTH', \&fDa],
 lYa=> ['BOTH', \&iCa],
 lZa=>['BOTH', \&fEa],
 lOa=>['BOTH', \&gWa],
#x1
#x1
 lSa=>['BOTH',  \&lSa],
 mAa=>['BOTH',  \&mAa],
 mBa=>['BOTH',  \&mBa],
 lVa=>['BOTH',  \&lVa],
 pBa=>['BOTH', \&pBa],
 iXa=>['BOTH', \&iXa],
 delf=> ['BOTH', \&jNz],
 lNa=> ['BOTH', \&hMz],
 lXa=> ['BOTH', \&gT],
 lQz=>['BOTH', \&wJz], 
 lOz=>['BOTH', \&xCz], 
 lNz=>['BOTH', \&xNz], 
 lMz =>['BOTH', \&vTz],       
 bDz => ['BOTH', \&bCz],
 gen_grp_form => ['BOTH', \&bXa],
#x2
 lAa=>['BOTH', \&lAa],
 kOa=>['BOTH', \&kOa],
 upgradeab=>['BOTH', \&upgradeab],
 convertmdb=>['BOTH', \&convert_msg_db],
 create_group=> ['BOTH', \&fHa],
 fD => ['BOTH', \&hP],
 hPz => ['BOTH', \&hNz],
 myforum=>['BOTH', \&xSz],
 find =>['BOTH', \&hK],
 finda =>['BOTH', \&wC],
 renamep =>['BOTH', \&sPa, 'ADM'],
 reg    => ['POST',  \&lR],
#x1
#x1
#x1
 activate => ['POST',  \&vW], 
 gQ => ['POST', \&mL, 'ADM'],
#x1
#x1
#x1
#x1
 rU => ['POST', \&tH, 'ADM'],
 hYz => ['POST', \&hXz, 'ADM'],
 iJz =>['POST', \&iJz, 'ADM'],
 qSa=>['POST', \&yTa, 'ADM'],
 get => ['GET', \&jL, 'ADM'],
 geta => ['GET', \&kAz, 'ADM'],
 retr=>['GET', 'iLa'],
 mDz => ['GET', \&mEz],
 iYz=>['GET', \&iXz],
#x2
#x1
#x1
 xQa=>['GET', \&xNa], 
 mform=>["GET", \&bFa], 
 modmp=>["GET", \&bEa],
 viewmp=>["GET", \&bIa],
 mimg =>["GET", \&bUa],
 procform=>['BOTH', \&cQa],
 viewtags=>['BOTH', \&fNa],
 ablist=>['BOTH', \&fLa],
 copythr=>['BOTH', \&fPa],
 lHa =>['GET', \&lHa],
 yKa=>["GET", \&yKa],
 yEa=>["GET", \&yWa],
 );

} #end of iJa

# end of abmain::hYa
1;
